import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPrivateLinkServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service#name DataAzurermPrivateLinkService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service#resource_group_name DataAzurermPrivateLinkService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service#timeouts DataAzurermPrivateLinkService#timeouts}
    */
    readonly timeouts?: DataAzurermPrivateLinkServiceTimeouts;
}
export declare class DataAzurermPrivateLinkServiceNatIpConfiguration extends cdktf.ComplexComputedList {
    get name(): string;
    get primary(): cdktf.IResolvable;
    get privateIpAddress(): string;
    get privateIpAddressVersion(): string;
    get subnetId(): string;
}
export interface DataAzurermPrivateLinkServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service#read DataAzurermPrivateLinkService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPrivateLinkServiceTimeoutsToTerraform(struct?: DataAzurermPrivateLinkServiceTimeoutsOutputReference | DataAzurermPrivateLinkServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPrivateLinkServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermPrivateLinkServiceTimeouts | undefined;
    set internalValue(value: DataAzurermPrivateLinkServiceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service azurerm_private_link_service}
*/
export declare class DataAzurermPrivateLinkService extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service azurerm_private_link_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPrivateLinkServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPrivateLinkServiceConfig);
    get alias(): string;
    get autoApprovalSubscriptionIds(): string[];
    get enableProxyProtocol(): cdktf.IResolvable;
    get id(): string;
    get loadBalancerFrontendIpConfigurationIds(): string[];
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    natIpConfiguration(index: string): DataAzurermPrivateLinkServiceNatIpConfiguration;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    get visibilitySubscriptionIds(): string[];
    private _timeouts;
    get timeouts(): DataAzurermPrivateLinkServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPrivateLinkServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermPrivateLinkServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
