import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPublicIpPrefixConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ip_prefix#name DataAzurermPublicIpPrefix#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ip_prefix#resource_group_name DataAzurermPublicIpPrefix#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ip_prefix#timeouts DataAzurermPublicIpPrefix#timeouts}
    */
    readonly timeouts?: DataAzurermPublicIpPrefixTimeouts;
}
export interface DataAzurermPublicIpPrefixTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ip_prefix#read DataAzurermPublicIpPrefix#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPublicIpPrefixTimeoutsToTerraform(struct?: DataAzurermPublicIpPrefixTimeoutsOutputReference | DataAzurermPublicIpPrefixTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPublicIpPrefixTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermPublicIpPrefixTimeouts | undefined;
    set internalValue(value: DataAzurermPublicIpPrefixTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/public_ip_prefix azurerm_public_ip_prefix}
*/
export declare class DataAzurermPublicIpPrefix extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/public_ip_prefix azurerm_public_ip_prefix} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPublicIpPrefixConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPublicIpPrefixConfig);
    get id(): string;
    get ipPrefix(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get prefixLength(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    tags(key: string): string | cdktf.IResolvable;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermPublicIpPrefixTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPublicIpPrefixTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermPublicIpPrefixTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
