import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPublicIpsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips#allocation_type DataAzurermPublicIps#allocation_type}
    */
    readonly allocationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips#attached DataAzurermPublicIps#attached}
    */
    readonly attached?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips#attachment_status DataAzurermPublicIps#attachment_status}
    */
    readonly attachmentStatus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips#name_prefix DataAzurermPublicIps#name_prefix}
    */
    readonly namePrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips#resource_group_name DataAzurermPublicIps#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips#timeouts DataAzurermPublicIps#timeouts}
    */
    readonly timeouts?: DataAzurermPublicIpsTimeouts;
}
export declare class DataAzurermPublicIpsPublicIps extends cdktf.ComplexComputedList {
    get domainNameLabel(): string;
    get fqdn(): string;
    get id(): string;
    get ipAddress(): string;
    get name(): string;
}
export interface DataAzurermPublicIpsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips#read DataAzurermPublicIps#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPublicIpsTimeoutsToTerraform(struct?: DataAzurermPublicIpsTimeoutsOutputReference | DataAzurermPublicIpsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPublicIpsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermPublicIpsTimeouts | undefined;
    set internalValue(value: DataAzurermPublicIpsTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips azurerm_public_ips}
*/
export declare class DataAzurermPublicIps extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips azurerm_public_ips} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPublicIpsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPublicIpsConfig);
    private _allocationType?;
    get allocationType(): string;
    set allocationType(value: string);
    resetAllocationType(): void;
    get allocationTypeInput(): string | undefined;
    private _attached?;
    get attached(): boolean | cdktf.IResolvable;
    set attached(value: boolean | cdktf.IResolvable);
    resetAttached(): void;
    get attachedInput(): boolean | cdktf.IResolvable | undefined;
    private _attachmentStatus?;
    get attachmentStatus(): string;
    set attachmentStatus(value: string);
    resetAttachmentStatus(): void;
    get attachmentStatusInput(): string | undefined;
    get id(): string;
    private _namePrefix?;
    get namePrefix(): string;
    set namePrefix(value: string);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    publicIps(index: string): DataAzurermPublicIpsPublicIps;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermPublicIpsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPublicIpsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermPublicIpsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
