import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermResourceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/resource_group#name DataAzurermResourceGroup#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/resource_group#timeouts DataAzurermResourceGroup#timeouts}
    */
    readonly timeouts?: DataAzurermResourceGroupTimeouts;
}
export interface DataAzurermResourceGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/resource_group#read DataAzurermResourceGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermResourceGroupTimeoutsToTerraform(struct?: DataAzurermResourceGroupTimeoutsOutputReference | DataAzurermResourceGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermResourceGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermResourceGroupTimeouts | undefined;
    set internalValue(value: DataAzurermResourceGroupTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/resource_group azurerm_resource_group}
*/
export declare class DataAzurermResourceGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/resource_group azurerm_resource_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermResourceGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermResourceGroupConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermResourceGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermResourceGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermResourceGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
