import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermResourcesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/resources#name DataAzurermResources#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/resources#required_tags DataAzurermResources#required_tags}
    */
    readonly requiredTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/resources#resource_group_name DataAzurermResources#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/resources#type DataAzurermResources#type}
    */
    readonly type?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/resources#timeouts DataAzurermResources#timeouts}
    */
    readonly timeouts?: DataAzurermResourcesTimeouts;
}
export declare class DataAzurermResourcesResources extends cdktf.ComplexComputedList {
    get id(): string;
    get location(): string;
    get name(): string;
    get tags(): {
        [key: string]: string;
    };
    get type(): string;
}
export interface DataAzurermResourcesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/resources#read DataAzurermResources#read}
    */
    readonly read?: string;
}
export declare function dataAzurermResourcesTimeoutsToTerraform(struct?: DataAzurermResourcesTimeoutsOutputReference | DataAzurermResourcesTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermResourcesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermResourcesTimeouts | undefined;
    set internalValue(value: DataAzurermResourcesTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/resources azurerm_resources}
*/
export declare class DataAzurermResources extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/resources azurerm_resources} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermResourcesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermResourcesConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _requiredTags?;
    get requiredTags(): {
        [key: string]: string;
    };
    set requiredTags(value: {
        [key: string]: string;
    });
    resetRequiredTags(): void;
    get requiredTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    resources(index: string): DataAzurermResourcesResources;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermResourcesTimeoutsOutputReference;
    putTimeouts(value: DataAzurermResourcesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermResourcesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
