import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermRouteFilterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/route_filter#name DataAzurermRouteFilter#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/route_filter#resource_group_name DataAzurermRouteFilter#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/route_filter#timeouts DataAzurermRouteFilter#timeouts}
    */
    readonly timeouts?: DataAzurermRouteFilterTimeouts;
}
export declare class DataAzurermRouteFilterRule extends cdktf.ComplexComputedList {
    get access(): string;
    get communities(): string[];
    get name(): string;
    get ruleType(): string;
}
export interface DataAzurermRouteFilterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/route_filter#read DataAzurermRouteFilter#read}
    */
    readonly read?: string;
}
export declare function dataAzurermRouteFilterTimeoutsToTerraform(struct?: DataAzurermRouteFilterTimeoutsOutputReference | DataAzurermRouteFilterTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermRouteFilterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermRouteFilterTimeouts | undefined;
    set internalValue(value: DataAzurermRouteFilterTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/route_filter azurerm_route_filter}
*/
export declare class DataAzurermRouteFilter extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/route_filter azurerm_route_filter} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermRouteFilterConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermRouteFilterConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    rule(index: string): DataAzurermRouteFilterRule;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermRouteFilterTimeoutsOutputReference;
    putTimeouts(value: DataAzurermRouteFilterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermRouteFilterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
