import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSentinelAlertRuleTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule_template#display_name DataAzurermSentinelAlertRuleTemplate#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule_template#log_analytics_workspace_id DataAzurermSentinelAlertRuleTemplate#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule_template#name DataAzurermSentinelAlertRuleTemplate#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule_template#timeouts DataAzurermSentinelAlertRuleTemplate#timeouts}
    */
    readonly timeouts?: DataAzurermSentinelAlertRuleTemplateTimeouts;
}
export declare class DataAzurermSentinelAlertRuleTemplateScheduledTemplate extends cdktf.ComplexComputedList {
    get description(): string;
    get query(): string;
    get queryFrequency(): string;
    get queryPeriod(): string;
    get severity(): string;
    get tactics(): string[];
    get triggerOperator(): string;
    get triggerThreshold(): number;
}
export declare class DataAzurermSentinelAlertRuleTemplateSecurityIncidentTemplate extends cdktf.ComplexComputedList {
    get description(): string;
    get productFilter(): string;
}
export interface DataAzurermSentinelAlertRuleTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule_template#read DataAzurermSentinelAlertRuleTemplate#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSentinelAlertRuleTemplateTimeoutsToTerraform(struct?: DataAzurermSentinelAlertRuleTemplateTimeoutsOutputReference | DataAzurermSentinelAlertRuleTemplateTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSentinelAlertRuleTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSentinelAlertRuleTemplateTimeouts | undefined;
    set internalValue(value: DataAzurermSentinelAlertRuleTemplateTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule_template azurerm_sentinel_alert_rule_template}
*/
export declare class DataAzurermSentinelAlertRuleTemplate extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule_template azurerm_sentinel_alert_rule_template} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSentinelAlertRuleTemplateConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSentinelAlertRuleTemplateConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    scheduledTemplate(index: string): DataAzurermSentinelAlertRuleTemplateScheduledTemplate;
    securityIncidentTemplate(index: string): DataAzurermSentinelAlertRuleTemplateSecurityIncidentTemplate;
    private _timeouts;
    get timeouts(): DataAzurermSentinelAlertRuleTemplateTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSentinelAlertRuleTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSentinelAlertRuleTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
