import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSharedImageGalleryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_gallery#name DataAzurermSharedImageGallery#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_gallery#resource_group_name DataAzurermSharedImageGallery#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_gallery#timeouts DataAzurermSharedImageGallery#timeouts}
    */
    readonly timeouts?: DataAzurermSharedImageGalleryTimeouts;
}
export interface DataAzurermSharedImageGalleryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_gallery#read DataAzurermSharedImageGallery#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSharedImageGalleryTimeoutsToTerraform(struct?: DataAzurermSharedImageGalleryTimeoutsOutputReference | DataAzurermSharedImageGalleryTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSharedImageGalleryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSharedImageGalleryTimeouts | undefined;
    set internalValue(value: DataAzurermSharedImageGalleryTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_gallery azurerm_shared_image_gallery}
*/
export declare class DataAzurermSharedImageGallery extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_gallery azurerm_shared_image_gallery} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSharedImageGalleryConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSharedImageGalleryConfig);
    get description(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    get uniqueName(): string;
    private _timeouts;
    get timeouts(): DataAzurermSharedImageGalleryTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSharedImageGalleryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSharedImageGalleryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
