import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSharedImageVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version#gallery_name DataAzurermSharedImageVersion#gallery_name}
    */
    readonly galleryName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version#image_name DataAzurermSharedImageVersion#image_name}
    */
    readonly imageName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version#name DataAzurermSharedImageVersion#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version#resource_group_name DataAzurermSharedImageVersion#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version#sort_versions_by_semver DataAzurermSharedImageVersion#sort_versions_by_semver}
    */
    readonly sortVersionsBySemver?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version#timeouts DataAzurermSharedImageVersion#timeouts}
    */
    readonly timeouts?: DataAzurermSharedImageVersionTimeouts;
}
export declare class DataAzurermSharedImageVersionTargetRegion extends cdktf.ComplexComputedList {
    get name(): string;
    get regionalReplicaCount(): number;
    get storageAccountType(): string;
}
export interface DataAzurermSharedImageVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version#read DataAzurermSharedImageVersion#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSharedImageVersionTimeoutsToTerraform(struct?: DataAzurermSharedImageVersionTimeoutsOutputReference | DataAzurermSharedImageVersionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSharedImageVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSharedImageVersionTimeouts | undefined;
    set internalValue(value: DataAzurermSharedImageVersionTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version azurerm_shared_image_version}
*/
export declare class DataAzurermSharedImageVersion extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version azurerm_shared_image_version} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSharedImageVersionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSharedImageVersionConfig);
    get excludeFromLatest(): cdktf.IResolvable;
    private _galleryName?;
    get galleryName(): string;
    set galleryName(value: string);
    get galleryNameInput(): string | undefined;
    get id(): string;
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    get imageNameInput(): string | undefined;
    get location(): string;
    get managedImageId(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get osDiskImageSizeGb(): number;
    get osDiskSnapshotId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sortVersionsBySemver?;
    get sortVersionsBySemver(): boolean | cdktf.IResolvable;
    set sortVersionsBySemver(value: boolean | cdktf.IResolvable);
    resetSortVersionsBySemver(): void;
    get sortVersionsBySemverInput(): boolean | cdktf.IResolvable | undefined;
    tags(key: string): string | cdktf.IResolvable;
    targetRegion(index: string): DataAzurermSharedImageVersionTargetRegion;
    private _timeouts;
    get timeouts(): DataAzurermSharedImageVersionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSharedImageVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSharedImageVersionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
