import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSiteRecoveryFabricConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/site_recovery_fabric#name DataAzurermSiteRecoveryFabric#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/site_recovery_fabric#recovery_vault_name DataAzurermSiteRecoveryFabric#recovery_vault_name}
    */
    readonly recoveryVaultName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/site_recovery_fabric#resource_group_name DataAzurermSiteRecoveryFabric#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/site_recovery_fabric#timeouts DataAzurermSiteRecoveryFabric#timeouts}
    */
    readonly timeouts?: DataAzurermSiteRecoveryFabricTimeouts;
}
export interface DataAzurermSiteRecoveryFabricTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/site_recovery_fabric#read DataAzurermSiteRecoveryFabric#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSiteRecoveryFabricTimeoutsToTerraform(struct?: DataAzurermSiteRecoveryFabricTimeoutsOutputReference | DataAzurermSiteRecoveryFabricTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSiteRecoveryFabricTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSiteRecoveryFabricTimeouts | undefined;
    set internalValue(value: DataAzurermSiteRecoveryFabricTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/site_recovery_fabric azurerm_site_recovery_fabric}
*/
export declare class DataAzurermSiteRecoveryFabric extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/site_recovery_fabric azurerm_site_recovery_fabric} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSiteRecoveryFabricConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSiteRecoveryFabricConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recoveryVaultName?;
    get recoveryVaultName(): string;
    set recoveryVaultName(value: string);
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermSiteRecoveryFabricTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSiteRecoveryFabricTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSiteRecoveryFabricTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
