import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSiteRecoveryReplicationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/site_recovery_replication_policy#name DataAzurermSiteRecoveryReplicationPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/site_recovery_replication_policy#recovery_vault_name DataAzurermSiteRecoveryReplicationPolicy#recovery_vault_name}
    */
    readonly recoveryVaultName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/site_recovery_replication_policy#resource_group_name DataAzurermSiteRecoveryReplicationPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/site_recovery_replication_policy#timeouts DataAzurermSiteRecoveryReplicationPolicy#timeouts}
    */
    readonly timeouts?: DataAzurermSiteRecoveryReplicationPolicyTimeouts;
}
export interface DataAzurermSiteRecoveryReplicationPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/site_recovery_replication_policy#read DataAzurermSiteRecoveryReplicationPolicy#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSiteRecoveryReplicationPolicyTimeoutsToTerraform(struct?: DataAzurermSiteRecoveryReplicationPolicyTimeoutsOutputReference | DataAzurermSiteRecoveryReplicationPolicyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSiteRecoveryReplicationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSiteRecoveryReplicationPolicyTimeouts | undefined;
    set internalValue(value: DataAzurermSiteRecoveryReplicationPolicyTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/site_recovery_replication_policy azurerm_site_recovery_replication_policy}
*/
export declare class DataAzurermSiteRecoveryReplicationPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/site_recovery_replication_policy azurerm_site_recovery_replication_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSiteRecoveryReplicationPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSiteRecoveryReplicationPolicyConfig);
    get applicationConsistentSnapshotFrequencyInMinutes(): number;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get recoveryPointRetentionInMinutes(): number;
    private _recoveryVaultName?;
    get recoveryVaultName(): string;
    set recoveryVaultName(value: string);
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermSiteRecoveryReplicationPolicyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSiteRecoveryReplicationPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSiteRecoveryReplicationPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
