import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSqlManagedInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_managed_instance#name DataAzurermSqlManagedInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_managed_instance#resource_group_name DataAzurermSqlManagedInstance#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_managed_instance#tags DataAzurermSqlManagedInstance#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_managed_instance#timeouts DataAzurermSqlManagedInstance#timeouts}
    */
    readonly timeouts?: DataAzurermSqlManagedInstanceTimeouts;
}
export declare class DataAzurermSqlManagedInstanceIdentity extends cdktf.ComplexComputedList {
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export interface DataAzurermSqlManagedInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_managed_instance#read DataAzurermSqlManagedInstance#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSqlManagedInstanceTimeoutsToTerraform(struct?: DataAzurermSqlManagedInstanceTimeoutsOutputReference | DataAzurermSqlManagedInstanceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSqlManagedInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSqlManagedInstanceTimeouts | undefined;
    set internalValue(value: DataAzurermSqlManagedInstanceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/sql_managed_instance azurerm_sql_managed_instance}
*/
export declare class DataAzurermSqlManagedInstance extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/sql_managed_instance azurerm_sql_managed_instance} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSqlManagedInstanceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSqlManagedInstanceConfig);
    get administratorLogin(): string;
    get collation(): string;
    get dnsZonePartnerId(): string;
    get fqdn(): string;
    get id(): string;
    identity(index: string): DataAzurermSqlManagedInstanceIdentity;
    get licenseType(): string;
    get location(): string;
    get minimumTlsVersion(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get proxyOverride(): string;
    get publicDataEndpointEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    get storageAccountType(): string;
    get storageSizeInGb(): number;
    get subnetId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get timezoneId(): string;
    get vcores(): number;
    private _timeouts;
    get timeouts(): DataAzurermSqlManagedInstanceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSqlManagedInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSqlManagedInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
