import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSqlServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_server#name DataAzurermSqlServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_server#resource_group_name DataAzurermSqlServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_server#timeouts DataAzurermSqlServer#timeouts}
    */
    readonly timeouts?: DataAzurermSqlServerTimeouts;
}
export declare class DataAzurermSqlServerIdentity extends cdktf.ComplexComputedList {
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export interface DataAzurermSqlServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_server#read DataAzurermSqlServer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSqlServerTimeoutsToTerraform(struct?: DataAzurermSqlServerTimeoutsOutputReference | DataAzurermSqlServerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSqlServerTimeouts | undefined;
    set internalValue(value: DataAzurermSqlServerTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/sql_server azurerm_sql_server}
*/
export declare class DataAzurermSqlServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/sql_server azurerm_sql_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSqlServerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSqlServerConfig);
    get administratorLogin(): string;
    get fqdn(): string;
    get id(): string;
    identity(index: string): DataAzurermSqlServerIdentity;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    get version(): string;
    private _timeouts;
    get timeouts(): DataAzurermSqlServerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSqlServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSqlServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
