import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStorageAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account#min_tls_version DataAzurermStorageAccount#min_tls_version}
    */
    readonly minTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account#name DataAzurermStorageAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account#resource_group_name DataAzurermStorageAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account#timeouts DataAzurermStorageAccount#timeouts}
    */
    readonly timeouts?: DataAzurermStorageAccountTimeouts;
}
export declare class DataAzurermStorageAccountCustomDomain extends cdktf.ComplexComputedList {
    get name(): string;
}
export interface DataAzurermStorageAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account#read DataAzurermStorageAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStorageAccountTimeoutsToTerraform(struct?: DataAzurermStorageAccountTimeoutsOutputReference | DataAzurermStorageAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStorageAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermStorageAccountTimeouts | undefined;
    set internalValue(value: DataAzurermStorageAccountTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account azurerm_storage_account}
*/
export declare class DataAzurermStorageAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account azurerm_storage_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStorageAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStorageAccountConfig);
    get accessTier(): string;
    get accountKind(): string;
    get accountReplicationType(): string;
    get accountTier(): string;
    get allowBlobPublicAccess(): cdktf.IResolvable;
    customDomain(index: string): DataAzurermStorageAccountCustomDomain;
    get enableHttpsTrafficOnly(): cdktf.IResolvable;
    get id(): string;
    get infrastructureEncryptionEnabled(): cdktf.IResolvable;
    get isHnsEnabled(): cdktf.IResolvable;
    get location(): string;
    private _minTlsVersion?;
    get minTlsVersion(): string;
    set minTlsVersion(value: string);
    resetMinTlsVersion(): void;
    get minTlsVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    get primaryBlobConnectionString(): string;
    get primaryBlobEndpoint(): string;
    get primaryBlobHost(): string;
    get primaryConnectionString(): string;
    get primaryDfsEndpoint(): string;
    get primaryDfsHost(): string;
    get primaryFileEndpoint(): string;
    get primaryFileHost(): string;
    get primaryLocation(): string;
    get primaryQueueEndpoint(): string;
    get primaryQueueHost(): string;
    get primaryTableEndpoint(): string;
    get primaryTableHost(): string;
    get primaryWebEndpoint(): string;
    get primaryWebHost(): string;
    get queueEncryptionKeyType(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get secondaryBlobConnectionString(): string;
    get secondaryBlobEndpoint(): string;
    get secondaryBlobHost(): string;
    get secondaryConnectionString(): string;
    get secondaryDfsEndpoint(): string;
    get secondaryDfsHost(): string;
    get secondaryFileEndpoint(): string;
    get secondaryFileHost(): string;
    get secondaryLocation(): string;
    get secondaryQueueEndpoint(): string;
    get secondaryQueueHost(): string;
    get secondaryTableEndpoint(): string;
    get secondaryTableHost(): string;
    get secondaryWebEndpoint(): string;
    get secondaryWebHost(): string;
    get tableEncryptionKeyType(): string;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermStorageAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStorageAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermStorageAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
