import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subscription#subscription_id DataAzurermSubscription#subscription_id}
    */
    readonly subscriptionId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subscription#timeouts DataAzurermSubscription#timeouts}
    */
    readonly timeouts?: DataAzurermSubscriptionTimeouts;
}
export interface DataAzurermSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subscription#read DataAzurermSubscription#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSubscriptionTimeoutsToTerraform(struct?: DataAzurermSubscriptionTimeoutsOutputReference | DataAzurermSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermSubscriptionTimeouts | undefined;
    set internalValue(value: DataAzurermSubscriptionTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/subscription azurerm_subscription}
*/
export declare class DataAzurermSubscription extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/subscription azurerm_subscription} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSubscriptionConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermSubscriptionConfig);
    get displayName(): string;
    get id(): string;
    get locationPlacementId(): string;
    get quotaId(): string;
    get spendingLimit(): string;
    get state(): string;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    resetSubscriptionId(): void;
    get subscriptionIdInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    get tenantId(): string;
    private _timeouts;
    get timeouts(): DataAzurermSubscriptionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
