import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermTemplateSpecVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/template_spec_version#name DataAzurermTemplateSpecVersion#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/template_spec_version#resource_group_name DataAzurermTemplateSpecVersion#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/template_spec_version#version DataAzurermTemplateSpecVersion#version}
    */
    readonly version: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/template_spec_version#timeouts DataAzurermTemplateSpecVersion#timeouts}
    */
    readonly timeouts?: DataAzurermTemplateSpecVersionTimeouts;
}
export interface DataAzurermTemplateSpecVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/template_spec_version#read DataAzurermTemplateSpecVersion#read}
    */
    readonly read?: string;
}
export declare function dataAzurermTemplateSpecVersionTimeoutsToTerraform(struct?: DataAzurermTemplateSpecVersionTimeoutsOutputReference | DataAzurermTemplateSpecVersionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermTemplateSpecVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermTemplateSpecVersionTimeouts | undefined;
    set internalValue(value: DataAzurermTemplateSpecVersionTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/template_spec_version azurerm_template_spec_version}
*/
export declare class DataAzurermTemplateSpecVersion extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/template_spec_version azurerm_template_spec_version} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermTemplateSpecVersionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermTemplateSpecVersionConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    get templateBody(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermTemplateSpecVersionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermTemplateSpecVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermTemplateSpecVersionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
