import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualMachineScaleSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set#name DataAzurermVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set#resource_group_name DataAzurermVirtualMachineScaleSet#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set#timeouts DataAzurermVirtualMachineScaleSet#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualMachineScaleSetTimeouts;
}
export declare class DataAzurermVirtualMachineScaleSetIdentity extends cdktf.ComplexComputedList {
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag extends cdktf.ComplexComputedList {
    get tag(): string;
    get type(): string;
}
export declare class DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress extends cdktf.ComplexComputedList {
    get domainNameLabel(): string;
    get idleTimeoutInMinutes(): number;
    get ipTag(): cdktf.IResolvable;
    get name(): string;
    get publicIpPrefixId(): string;
}
export declare class DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfiguration extends cdktf.ComplexComputedList {
    get applicationGatewayBackendAddressPoolIds(): string[];
    get applicationSecurityGroupIds(): string[];
    get loadBalancerBackendAddressPoolIds(): string[];
    get loadBalancerInboundNatRulesIds(): string[];
    get name(): string;
    get primary(): cdktf.IResolvable;
    get publicIpAddress(): cdktf.IResolvable;
    get subnetId(): string;
    get version(): string;
}
export declare class DataAzurermVirtualMachineScaleSetNetworkInterface extends cdktf.ComplexComputedList {
    get dnsServers(): string[];
    get enableAcceleratedNetworking(): cdktf.IResolvable;
    get enableIpForwarding(): cdktf.IResolvable;
    get ipConfiguration(): cdktf.IResolvable;
    get name(): string;
    get networkSecurityGroupId(): string;
    get primary(): cdktf.IResolvable;
}
export interface DataAzurermVirtualMachineScaleSetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set#read DataAzurermVirtualMachineScaleSet#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualMachineScaleSetTimeoutsToTerraform(struct?: DataAzurermVirtualMachineScaleSetTimeoutsOutputReference | DataAzurermVirtualMachineScaleSetTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualMachineScaleSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermVirtualMachineScaleSetTimeouts | undefined;
    set internalValue(value: DataAzurermVirtualMachineScaleSetTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set azurerm_virtual_machine_scale_set}
*/
export declare class DataAzurermVirtualMachineScaleSet extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set azurerm_virtual_machine_scale_set} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualMachineScaleSetConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualMachineScaleSetConfig);
    get id(): string;
    identity(index: string): DataAzurermVirtualMachineScaleSetIdentity;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    networkInterface(index: string): DataAzurermVirtualMachineScaleSetNetworkInterface;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermVirtualMachineScaleSetTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualMachineScaleSetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermVirtualMachineScaleSetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
