import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway#name DataAzurermVpnGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway#resource_group_name DataAzurermVpnGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway#timeouts DataAzurermVpnGateway#timeouts}
    */
    readonly timeouts?: DataAzurermVpnGatewayTimeouts;
}
export declare class DataAzurermVpnGatewayBgpSettingsInstance0BgpPeeringAddress extends cdktf.ComplexComputedList {
    get customIps(): string[];
    get defaultIps(): string[];
    get ipConfigurationId(): string;
    get tunnelIps(): string[];
}
export declare class DataAzurermVpnGatewayBgpSettingsInstance1BgpPeeringAddress extends cdktf.ComplexComputedList {
    get customIps(): string[];
    get defaultIps(): string[];
    get ipConfigurationId(): string;
    get tunnelIps(): string[];
}
export declare class DataAzurermVpnGatewayBgpSettings extends cdktf.ComplexComputedList {
    get asn(): number;
    get bgpPeeringAddress(): string;
    get instance0BgpPeeringAddress(): cdktf.IResolvable;
    get instance1BgpPeeringAddress(): cdktf.IResolvable;
    get peerWeight(): number;
}
export interface DataAzurermVpnGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway#read DataAzurermVpnGateway#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVpnGatewayTimeoutsToTerraform(struct?: DataAzurermVpnGatewayTimeoutsOutputReference | DataAzurermVpnGatewayTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVpnGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermVpnGatewayTimeouts | undefined;
    set internalValue(value: DataAzurermVpnGatewayTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway azurerm_vpn_gateway}
*/
export declare class DataAzurermVpnGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/vpn_gateway azurerm_vpn_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVpnGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVpnGatewayConfig);
    bgpSettings(index: string): DataAzurermVpnGatewayBgpSettings;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get scaleUnit(): number;
    tags(key: string): string | cdktf.IResolvable;
    get virtualHubId(): string;
    private _timeouts;
    get timeouts(): DataAzurermVpnGatewayTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVpnGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermVpnGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
