import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryDatasetHttpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#additional_properties DataFactoryDatasetHttp#additional_properties}
    */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#annotations DataFactoryDatasetHttp#annotations}
    */
    readonly annotations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#data_factory_id DataFactoryDatasetHttp#data_factory_id}
    */
    readonly dataFactoryId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#data_factory_name DataFactoryDatasetHttp#data_factory_name}
    */
    readonly dataFactoryName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#description DataFactoryDatasetHttp#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#folder DataFactoryDatasetHttp#folder}
    */
    readonly folder?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#linked_service_name DataFactoryDatasetHttp#linked_service_name}
    */
    readonly linkedServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#name DataFactoryDatasetHttp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#parameters DataFactoryDatasetHttp#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#relative_url DataFactoryDatasetHttp#relative_url}
    */
    readonly relativeUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#request_body DataFactoryDatasetHttp#request_body}
    */
    readonly requestBody?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#request_method DataFactoryDatasetHttp#request_method}
    */
    readonly requestMethod?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#resource_group_name DataFactoryDatasetHttp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * schema_column block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#schema_column DataFactoryDatasetHttp#schema_column}
    */
    readonly schemaColumn?: DataFactoryDatasetHttpSchemaColumn[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#timeouts DataFactoryDatasetHttp#timeouts}
    */
    readonly timeouts?: DataFactoryDatasetHttpTimeouts;
}
export interface DataFactoryDatasetHttpSchemaColumn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#description DataFactoryDatasetHttp#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#name DataFactoryDatasetHttp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#type DataFactoryDatasetHttp#type}
    */
    readonly type?: string;
}
export declare function dataFactoryDatasetHttpSchemaColumnToTerraform(struct?: DataFactoryDatasetHttpSchemaColumn | cdktf.IResolvable): any;
export interface DataFactoryDatasetHttpTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#create DataFactoryDatasetHttp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#delete DataFactoryDatasetHttp#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#read DataFactoryDatasetHttp#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http#update DataFactoryDatasetHttp#update}
    */
    readonly update?: string;
}
export declare function dataFactoryDatasetHttpTimeoutsToTerraform(struct?: DataFactoryDatasetHttpTimeoutsOutputReference | DataFactoryDatasetHttpTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryDatasetHttpTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataFactoryDatasetHttpTimeouts | undefined;
    set internalValue(value: DataFactoryDatasetHttpTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http azurerm_data_factory_dataset_http}
*/
export declare class DataFactoryDatasetHttp extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_http azurerm_data_factory_dataset_http} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryDatasetHttpConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryDatasetHttpConfig);
    private _additionalProperties?;
    get additionalProperties(): {
        [key: string]: string;
    };
    set additionalProperties(value: {
        [key: string]: string;
    });
    resetAdditionalProperties(): void;
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    resetDataFactoryId(): void;
    get dataFactoryIdInput(): string | undefined;
    private _dataFactoryName?;
    get dataFactoryName(): string;
    set dataFactoryName(value: string);
    resetDataFactoryName(): void;
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    get id(): string;
    private _linkedServiceName?;
    get linkedServiceName(): string;
    set linkedServiceName(value: string);
    get linkedServiceNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _relativeUrl?;
    get relativeUrl(): string;
    set relativeUrl(value: string);
    resetRelativeUrl(): void;
    get relativeUrlInput(): string | undefined;
    private _requestBody?;
    get requestBody(): string;
    set requestBody(value: string);
    resetRequestBody(): void;
    get requestBodyInput(): string | undefined;
    private _requestMethod?;
    get requestMethod(): string;
    set requestMethod(value: string);
    resetRequestMethod(): void;
    get requestMethodInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _schemaColumn?;
    get schemaColumn(): DataFactoryDatasetHttpSchemaColumn[] | cdktf.IResolvable;
    set schemaColumn(value: DataFactoryDatasetHttpSchemaColumn[] | cdktf.IResolvable);
    resetSchemaColumn(): void;
    get schemaColumnInput(): cdktf.IResolvable | DataFactoryDatasetHttpSchemaColumn[] | undefined;
    private _timeouts;
    get timeouts(): DataFactoryDatasetHttpTimeoutsOutputReference;
    putTimeouts(value: DataFactoryDatasetHttpTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataFactoryDatasetHttpTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
