import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryLinkedServiceAzureFileStorageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#additional_properties DataFactoryLinkedServiceAzureFileStorage#additional_properties}
    */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#annotations DataFactoryLinkedServiceAzureFileStorage#annotations}
    */
    readonly annotations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#connection_string DataFactoryLinkedServiceAzureFileStorage#connection_string}
    */
    readonly connectionString: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#data_factory_id DataFactoryLinkedServiceAzureFileStorage#data_factory_id}
    */
    readonly dataFactoryId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#data_factory_name DataFactoryLinkedServiceAzureFileStorage#data_factory_name}
    */
    readonly dataFactoryName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#description DataFactoryLinkedServiceAzureFileStorage#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#file_share DataFactoryLinkedServiceAzureFileStorage#file_share}
    */
    readonly fileShare?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#host DataFactoryLinkedServiceAzureFileStorage#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#integration_runtime_name DataFactoryLinkedServiceAzureFileStorage#integration_runtime_name}
    */
    readonly integrationRuntimeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#name DataFactoryLinkedServiceAzureFileStorage#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#parameters DataFactoryLinkedServiceAzureFileStorage#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#password DataFactoryLinkedServiceAzureFileStorage#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#resource_group_name DataFactoryLinkedServiceAzureFileStorage#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#user_id DataFactoryLinkedServiceAzureFileStorage#user_id}
    */
    readonly userId?: string;
    /**
    * key_vault_password block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#key_vault_password DataFactoryLinkedServiceAzureFileStorage#key_vault_password}
    */
    readonly keyVaultPassword?: DataFactoryLinkedServiceAzureFileStorageKeyVaultPassword;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#timeouts DataFactoryLinkedServiceAzureFileStorage#timeouts}
    */
    readonly timeouts?: DataFactoryLinkedServiceAzureFileStorageTimeouts;
}
export interface DataFactoryLinkedServiceAzureFileStorageKeyVaultPassword {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#linked_service_name DataFactoryLinkedServiceAzureFileStorage#linked_service_name}
    */
    readonly linkedServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#secret_name DataFactoryLinkedServiceAzureFileStorage#secret_name}
    */
    readonly secretName: string;
}
export declare function dataFactoryLinkedServiceAzureFileStorageKeyVaultPasswordToTerraform(struct?: DataFactoryLinkedServiceAzureFileStorageKeyVaultPasswordOutputReference | DataFactoryLinkedServiceAzureFileStorageKeyVaultPassword): any;
export declare class DataFactoryLinkedServiceAzureFileStorageKeyVaultPasswordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataFactoryLinkedServiceAzureFileStorageKeyVaultPassword | undefined;
    set internalValue(value: DataFactoryLinkedServiceAzureFileStorageKeyVaultPassword | undefined);
    private _linkedServiceName?;
    get linkedServiceName(): string;
    set linkedServiceName(value: string);
    get linkedServiceNameInput(): string | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
}
export interface DataFactoryLinkedServiceAzureFileStorageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#create DataFactoryLinkedServiceAzureFileStorage#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#delete DataFactoryLinkedServiceAzureFileStorage#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#read DataFactoryLinkedServiceAzureFileStorage#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage#update DataFactoryLinkedServiceAzureFileStorage#update}
    */
    readonly update?: string;
}
export declare function dataFactoryLinkedServiceAzureFileStorageTimeoutsToTerraform(struct?: DataFactoryLinkedServiceAzureFileStorageTimeoutsOutputReference | DataFactoryLinkedServiceAzureFileStorageTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryLinkedServiceAzureFileStorageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataFactoryLinkedServiceAzureFileStorageTimeouts | undefined;
    set internalValue(value: DataFactoryLinkedServiceAzureFileStorageTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage azurerm_data_factory_linked_service_azure_file_storage}
*/
export declare class DataFactoryLinkedServiceAzureFileStorage extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_file_storage azurerm_data_factory_linked_service_azure_file_storage} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryLinkedServiceAzureFileStorageConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryLinkedServiceAzureFileStorageConfig);
    private _additionalProperties?;
    get additionalProperties(): {
        [key: string]: string;
    };
    set additionalProperties(value: {
        [key: string]: string;
    });
    resetAdditionalProperties(): void;
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _connectionString?;
    get connectionString(): string;
    set connectionString(value: string);
    get connectionStringInput(): string | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    resetDataFactoryId(): void;
    get dataFactoryIdInput(): string | undefined;
    private _dataFactoryName?;
    get dataFactoryName(): string;
    set dataFactoryName(value: string);
    resetDataFactoryName(): void;
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _fileShare?;
    get fileShare(): string;
    set fileShare(value: string);
    resetFileShare(): void;
    get fileShareInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    get id(): string;
    private _integrationRuntimeName?;
    get integrationRuntimeName(): string;
    set integrationRuntimeName(value: string);
    resetIntegrationRuntimeName(): void;
    get integrationRuntimeNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    resetUserId(): void;
    get userIdInput(): string | undefined;
    private _keyVaultPassword;
    get keyVaultPassword(): DataFactoryLinkedServiceAzureFileStorageKeyVaultPasswordOutputReference;
    putKeyVaultPassword(value: DataFactoryLinkedServiceAzureFileStorageKeyVaultPassword): void;
    resetKeyVaultPassword(): void;
    get keyVaultPasswordInput(): DataFactoryLinkedServiceAzureFileStorageKeyVaultPassword | undefined;
    private _timeouts;
    get timeouts(): DataFactoryLinkedServiceAzureFileStorageTimeoutsOutputReference;
    putTimeouts(value: DataFactoryLinkedServiceAzureFileStorageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataFactoryLinkedServiceAzureFileStorageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
