import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryTriggerCustomEventConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#activated DataFactoryTriggerCustomEvent#activated}
    */
    readonly activated?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#additional_properties DataFactoryTriggerCustomEvent#additional_properties}
    */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#annotations DataFactoryTriggerCustomEvent#annotations}
    */
    readonly annotations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#data_factory_id DataFactoryTriggerCustomEvent#data_factory_id}
    */
    readonly dataFactoryId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#description DataFactoryTriggerCustomEvent#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#eventgrid_topic_id DataFactoryTriggerCustomEvent#eventgrid_topic_id}
    */
    readonly eventgridTopicId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#events DataFactoryTriggerCustomEvent#events}
    */
    readonly events: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#name DataFactoryTriggerCustomEvent#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#subject_begins_with DataFactoryTriggerCustomEvent#subject_begins_with}
    */
    readonly subjectBeginsWith?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#subject_ends_with DataFactoryTriggerCustomEvent#subject_ends_with}
    */
    readonly subjectEndsWith?: string;
    /**
    * pipeline block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#pipeline DataFactoryTriggerCustomEvent#pipeline}
    */
    readonly pipeline: DataFactoryTriggerCustomEventPipeline[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#timeouts DataFactoryTriggerCustomEvent#timeouts}
    */
    readonly timeouts?: DataFactoryTriggerCustomEventTimeouts;
}
export interface DataFactoryTriggerCustomEventPipeline {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#name DataFactoryTriggerCustomEvent#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#parameters DataFactoryTriggerCustomEvent#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryTriggerCustomEventPipelineToTerraform(struct?: DataFactoryTriggerCustomEventPipeline | cdktf.IResolvable): any;
export interface DataFactoryTriggerCustomEventTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#create DataFactoryTriggerCustomEvent#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#delete DataFactoryTriggerCustomEvent#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#read DataFactoryTriggerCustomEvent#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event#update DataFactoryTriggerCustomEvent#update}
    */
    readonly update?: string;
}
export declare function dataFactoryTriggerCustomEventTimeoutsToTerraform(struct?: DataFactoryTriggerCustomEventTimeoutsOutputReference | DataFactoryTriggerCustomEventTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryTriggerCustomEventTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataFactoryTriggerCustomEventTimeouts | undefined;
    set internalValue(value: DataFactoryTriggerCustomEventTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event azurerm_data_factory_trigger_custom_event}
*/
export declare class DataFactoryTriggerCustomEvent extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_custom_event azurerm_data_factory_trigger_custom_event} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryTriggerCustomEventConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryTriggerCustomEventConfig);
    private _activated?;
    get activated(): boolean | cdktf.IResolvable;
    set activated(value: boolean | cdktf.IResolvable);
    resetActivated(): void;
    get activatedInput(): boolean | cdktf.IResolvable | undefined;
    private _additionalProperties?;
    get additionalProperties(): {
        [key: string]: string;
    };
    set additionalProperties(value: {
        [key: string]: string;
    });
    resetAdditionalProperties(): void;
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    get dataFactoryIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _eventgridTopicId?;
    get eventgridTopicId(): string;
    set eventgridTopicId(value: string);
    get eventgridTopicIdInput(): string | undefined;
    private _events?;
    get events(): string[];
    set events(value: string[]);
    get eventsInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _subjectBeginsWith?;
    get subjectBeginsWith(): string;
    set subjectBeginsWith(value: string);
    resetSubjectBeginsWith(): void;
    get subjectBeginsWithInput(): string | undefined;
    private _subjectEndsWith?;
    get subjectEndsWith(): string;
    set subjectEndsWith(value: string);
    resetSubjectEndsWith(): void;
    get subjectEndsWithInput(): string | undefined;
    private _pipeline?;
    get pipeline(): DataFactoryTriggerCustomEventPipeline[] | cdktf.IResolvable;
    set pipeline(value: DataFactoryTriggerCustomEventPipeline[] | cdktf.IResolvable);
    get pipelineInput(): cdktf.IResolvable | DataFactoryTriggerCustomEventPipeline[] | undefined;
    private _timeouts;
    get timeouts(): DataFactoryTriggerCustomEventTimeoutsOutputReference;
    putTimeouts(value: DataFactoryTriggerCustomEventTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataFactoryTriggerCustomEventTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
