import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabaseMigrationProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/database_migration_project#location DatabaseMigrationProject#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/database_migration_project#name DatabaseMigrationProject#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/database_migration_project#resource_group_name DatabaseMigrationProject#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/database_migration_project#service_name DatabaseMigrationProject#service_name}
    */
    readonly serviceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/database_migration_project#source_platform DatabaseMigrationProject#source_platform}
    */
    readonly sourcePlatform: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/database_migration_project#tags DatabaseMigrationProject#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/database_migration_project#target_platform DatabaseMigrationProject#target_platform}
    */
    readonly targetPlatform: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/database_migration_project#timeouts DatabaseMigrationProject#timeouts}
    */
    readonly timeouts?: DatabaseMigrationProjectTimeouts;
}
export interface DatabaseMigrationProjectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/database_migration_project#create DatabaseMigrationProject#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/database_migration_project#delete DatabaseMigrationProject#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/database_migration_project#read DatabaseMigrationProject#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/database_migration_project#update DatabaseMigrationProject#update}
    */
    readonly update?: string;
}
export declare function databaseMigrationProjectTimeoutsToTerraform(struct?: DatabaseMigrationProjectTimeoutsOutputReference | DatabaseMigrationProjectTimeouts | cdktf.IResolvable): any;
export declare class DatabaseMigrationProjectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DatabaseMigrationProjectTimeouts | undefined;
    set internalValue(value: DatabaseMigrationProjectTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/database_migration_project azurerm_database_migration_project}
*/
export declare class DatabaseMigrationProject extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/database_migration_project azurerm_database_migration_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseMigrationProjectConfig
    */
    constructor(scope: Construct, id: string, config: DatabaseMigrationProjectConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    private _sourcePlatform?;
    get sourcePlatform(): string;
    set sourcePlatform(value: string);
    get sourcePlatformInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _targetPlatform?;
    get targetPlatform(): string;
    set targetPlatform(value: string);
    get targetPlatformInput(): string | undefined;
    private _timeouts;
    get timeouts(): DatabaseMigrationProjectTimeoutsOutputReference;
    putTimeouts(value: DatabaseMigrationProjectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DatabaseMigrationProjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
