import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DevTestScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#lab_name DevTestSchedule#lab_name}
    */
    readonly labName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#location DevTestSchedule#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#name DevTestSchedule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#resource_group_name DevTestSchedule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#status DevTestSchedule#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#tags DevTestSchedule#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#task_type DevTestSchedule#task_type}
    */
    readonly taskType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#time_zone_id DevTestSchedule#time_zone_id}
    */
    readonly timeZoneId: string;
    /**
    * daily_recurrence block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#daily_recurrence DevTestSchedule#daily_recurrence}
    */
    readonly dailyRecurrence?: DevTestScheduleDailyRecurrence;
    /**
    * hourly_recurrence block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#hourly_recurrence DevTestSchedule#hourly_recurrence}
    */
    readonly hourlyRecurrence?: DevTestScheduleHourlyRecurrence;
    /**
    * notification_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#notification_settings DevTestSchedule#notification_settings}
    */
    readonly notificationSettings: DevTestScheduleNotificationSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#timeouts DevTestSchedule#timeouts}
    */
    readonly timeouts?: DevTestScheduleTimeouts;
    /**
    * weekly_recurrence block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#weekly_recurrence DevTestSchedule#weekly_recurrence}
    */
    readonly weeklyRecurrence?: DevTestScheduleWeeklyRecurrence;
}
export interface DevTestScheduleDailyRecurrence {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#time DevTestSchedule#time}
    */
    readonly time: string;
}
export declare function devTestScheduleDailyRecurrenceToTerraform(struct?: DevTestScheduleDailyRecurrenceOutputReference | DevTestScheduleDailyRecurrence): any;
export declare class DevTestScheduleDailyRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DevTestScheduleDailyRecurrence | undefined;
    set internalValue(value: DevTestScheduleDailyRecurrence | undefined);
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
}
export interface DevTestScheduleHourlyRecurrence {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#minute DevTestSchedule#minute}
    */
    readonly minute: number;
}
export declare function devTestScheduleHourlyRecurrenceToTerraform(struct?: DevTestScheduleHourlyRecurrenceOutputReference | DevTestScheduleHourlyRecurrence): any;
export declare class DevTestScheduleHourlyRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DevTestScheduleHourlyRecurrence | undefined;
    set internalValue(value: DevTestScheduleHourlyRecurrence | undefined);
    private _minute?;
    get minute(): number;
    set minute(value: number);
    get minuteInput(): number | undefined;
}
export interface DevTestScheduleNotificationSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#status DevTestSchedule#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#time_in_minutes DevTestSchedule#time_in_minutes}
    */
    readonly timeInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#webhook_url DevTestSchedule#webhook_url}
    */
    readonly webhookUrl?: string;
}
export declare function devTestScheduleNotificationSettingsToTerraform(struct?: DevTestScheduleNotificationSettingsOutputReference | DevTestScheduleNotificationSettings): any;
export declare class DevTestScheduleNotificationSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DevTestScheduleNotificationSettings | undefined;
    set internalValue(value: DevTestScheduleNotificationSettings | undefined);
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _timeInMinutes?;
    get timeInMinutes(): number;
    set timeInMinutes(value: number);
    resetTimeInMinutes(): void;
    get timeInMinutesInput(): number | undefined;
    private _webhookUrl?;
    get webhookUrl(): string;
    set webhookUrl(value: string);
    resetWebhookUrl(): void;
    get webhookUrlInput(): string | undefined;
}
export interface DevTestScheduleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#create DevTestSchedule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#delete DevTestSchedule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#read DevTestSchedule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#update DevTestSchedule#update}
    */
    readonly update?: string;
}
export declare function devTestScheduleTimeoutsToTerraform(struct?: DevTestScheduleTimeoutsOutputReference | DevTestScheduleTimeouts | cdktf.IResolvable): any;
export declare class DevTestScheduleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DevTestScheduleTimeouts | undefined;
    set internalValue(value: DevTestScheduleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DevTestScheduleWeeklyRecurrence {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#time DevTestSchedule#time}
    */
    readonly time: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule#week_days DevTestSchedule#week_days}
    */
    readonly weekDays?: string[];
}
export declare function devTestScheduleWeeklyRecurrenceToTerraform(struct?: DevTestScheduleWeeklyRecurrenceOutputReference | DevTestScheduleWeeklyRecurrence): any;
export declare class DevTestScheduleWeeklyRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DevTestScheduleWeeklyRecurrence | undefined;
    set internalValue(value: DevTestScheduleWeeklyRecurrence | undefined);
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
    private _weekDays?;
    get weekDays(): string[];
    set weekDays(value: string[]);
    resetWeekDays(): void;
    get weekDaysInput(): string[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule azurerm_dev_test_schedule}
*/
export declare class DevTestSchedule extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_schedule azurerm_dev_test_schedule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DevTestScheduleConfig
    */
    constructor(scope: Construct, id: string, config: DevTestScheduleConfig);
    get id(): string;
    private _labName?;
    get labName(): string;
    set labName(value: string);
    get labNameInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _taskType?;
    get taskType(): string;
    set taskType(value: string);
    get taskTypeInput(): string | undefined;
    private _timeZoneId?;
    get timeZoneId(): string;
    set timeZoneId(value: string);
    get timeZoneIdInput(): string | undefined;
    private _dailyRecurrence;
    get dailyRecurrence(): DevTestScheduleDailyRecurrenceOutputReference;
    putDailyRecurrence(value: DevTestScheduleDailyRecurrence): void;
    resetDailyRecurrence(): void;
    get dailyRecurrenceInput(): DevTestScheduleDailyRecurrence | undefined;
    private _hourlyRecurrence;
    get hourlyRecurrence(): DevTestScheduleHourlyRecurrenceOutputReference;
    putHourlyRecurrence(value: DevTestScheduleHourlyRecurrence): void;
    resetHourlyRecurrence(): void;
    get hourlyRecurrenceInput(): DevTestScheduleHourlyRecurrence | undefined;
    private _notificationSettings;
    get notificationSettings(): DevTestScheduleNotificationSettingsOutputReference;
    putNotificationSettings(value: DevTestScheduleNotificationSettings): void;
    get notificationSettingsInput(): DevTestScheduleNotificationSettings | undefined;
    private _timeouts;
    get timeouts(): DevTestScheduleTimeoutsOutputReference;
    putTimeouts(value: DevTestScheduleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DevTestScheduleTimeouts | undefined;
    private _weeklyRecurrence;
    get weeklyRecurrence(): DevTestScheduleWeeklyRecurrenceOutputReference;
    putWeeklyRecurrence(value: DevTestScheduleWeeklyRecurrence): void;
    resetWeeklyRecurrence(): void;
    get weeklyRecurrenceInput(): DevTestScheduleWeeklyRecurrence | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
