import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DiskPoolIscsiTargetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#acl_mode DiskPoolIscsiTarget#acl_mode}
    */
    readonly aclMode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#disks_pool_id DiskPoolIscsiTarget#disks_pool_id}
    */
    readonly disksPoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#name DiskPoolIscsiTarget#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#target_iqn DiskPoolIscsiTarget#target_iqn}
    */
    readonly targetIqn?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#timeouts DiskPoolIscsiTarget#timeouts}
    */
    readonly timeouts?: DiskPoolIscsiTargetTimeouts;
}
export interface DiskPoolIscsiTargetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#create DiskPoolIscsiTarget#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#delete DiskPoolIscsiTarget#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target#read DiskPoolIscsiTarget#read}
    */
    readonly read?: string;
}
export declare function diskPoolIscsiTargetTimeoutsToTerraform(struct?: DiskPoolIscsiTargetTimeoutsOutputReference | DiskPoolIscsiTargetTimeouts | cdktf.IResolvable): any;
export declare class DiskPoolIscsiTargetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DiskPoolIscsiTargetTimeouts | undefined;
    set internalValue(value: DiskPoolIscsiTargetTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target azurerm_disk_pool_iscsi_target}
*/
export declare class DiskPoolIscsiTarget extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/disk_pool_iscsi_target azurerm_disk_pool_iscsi_target} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DiskPoolIscsiTargetConfig
    */
    constructor(scope: Construct, id: string, config: DiskPoolIscsiTargetConfig);
    private _aclMode?;
    get aclMode(): string;
    set aclMode(value: string);
    get aclModeInput(): string | undefined;
    private _disksPoolId?;
    get disksPoolId(): string;
    set disksPoolId(value: string);
    get disksPoolIdInput(): string | undefined;
    get endpoints(): string[];
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get port(): number;
    private _targetIqn?;
    get targetIqn(): string;
    set targetIqn(value: string);
    resetTargetIqn(): void;
    get targetIqnInput(): string | undefined;
    private _timeouts;
    get timeouts(): DiskPoolIscsiTargetTimeoutsOutputReference;
    putTimeouts(value: DiskPoolIscsiTargetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DiskPoolIscsiTargetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
