import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HpcCacheConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#cache_size_in_gb HpcCache#cache_size_in_gb}
    */
    readonly cacheSizeInGb: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#location HpcCache#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#mtu HpcCache#mtu}
    */
    readonly mtu?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#name HpcCache#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#ntp_server HpcCache#ntp_server}
    */
    readonly ntpServer?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#resource_group_name HpcCache#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#root_squash_enabled HpcCache#root_squash_enabled}
    */
    readonly rootSquashEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#sku_name HpcCache#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#subnet_id HpcCache#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#tags HpcCache#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * default_access_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#default_access_policy HpcCache#default_access_policy}
    */
    readonly defaultAccessPolicy?: HpcCacheDefaultAccessPolicy;
    /**
    * directory_active_directory block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#directory_active_directory HpcCache#directory_active_directory}
    */
    readonly directoryActiveDirectory?: HpcCacheDirectoryActiveDirectory;
    /**
    * directory_flat_file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#directory_flat_file HpcCache#directory_flat_file}
    */
    readonly directoryFlatFile?: HpcCacheDirectoryFlatFile;
    /**
    * directory_ldap block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#directory_ldap HpcCache#directory_ldap}
    */
    readonly directoryLdap?: HpcCacheDirectoryLdap;
    /**
    * dns block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#dns HpcCache#dns}
    */
    readonly dns?: HpcCacheDns;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#timeouts HpcCache#timeouts}
    */
    readonly timeouts?: HpcCacheTimeouts;
}
export interface HpcCacheDefaultAccessPolicyAccessRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#access HpcCache#access}
    */
    readonly access: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#anonymous_gid HpcCache#anonymous_gid}
    */
    readonly anonymousGid?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#anonymous_uid HpcCache#anonymous_uid}
    */
    readonly anonymousUid?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#filter HpcCache#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#root_squash_enabled HpcCache#root_squash_enabled}
    */
    readonly rootSquashEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#scope HpcCache#scope}
    */
    readonly scope: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#submount_access_enabled HpcCache#submount_access_enabled}
    */
    readonly submountAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#suid_enabled HpcCache#suid_enabled}
    */
    readonly suidEnabled?: boolean | cdktf.IResolvable;
}
export declare function hpcCacheDefaultAccessPolicyAccessRuleToTerraform(struct?: HpcCacheDefaultAccessPolicyAccessRule | cdktf.IResolvable): any;
export interface HpcCacheDefaultAccessPolicy {
    /**
    * access_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#access_rule HpcCache#access_rule}
    */
    readonly accessRule: HpcCacheDefaultAccessPolicyAccessRule[] | cdktf.IResolvable;
}
export declare function hpcCacheDefaultAccessPolicyToTerraform(struct?: HpcCacheDefaultAccessPolicyOutputReference | HpcCacheDefaultAccessPolicy): any;
export declare class HpcCacheDefaultAccessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HpcCacheDefaultAccessPolicy | undefined;
    set internalValue(value: HpcCacheDefaultAccessPolicy | undefined);
    private _accessRule?;
    get accessRule(): HpcCacheDefaultAccessPolicyAccessRule[] | cdktf.IResolvable;
    set accessRule(value: HpcCacheDefaultAccessPolicyAccessRule[] | cdktf.IResolvable);
    get accessRuleInput(): cdktf.IResolvable | HpcCacheDefaultAccessPolicyAccessRule[] | undefined;
}
export interface HpcCacheDirectoryActiveDirectory {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#cache_netbios_name HpcCache#cache_netbios_name}
    */
    readonly cacheNetbiosName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#dns_primary_ip HpcCache#dns_primary_ip}
    */
    readonly dnsPrimaryIp: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#dns_secondary_ip HpcCache#dns_secondary_ip}
    */
    readonly dnsSecondaryIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#domain_name HpcCache#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#domain_netbios_name HpcCache#domain_netbios_name}
    */
    readonly domainNetbiosName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#password HpcCache#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#username HpcCache#username}
    */
    readonly username: string;
}
export declare function hpcCacheDirectoryActiveDirectoryToTerraform(struct?: HpcCacheDirectoryActiveDirectoryOutputReference | HpcCacheDirectoryActiveDirectory): any;
export declare class HpcCacheDirectoryActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HpcCacheDirectoryActiveDirectory | undefined;
    set internalValue(value: HpcCacheDirectoryActiveDirectory | undefined);
    private _cacheNetbiosName?;
    get cacheNetbiosName(): string;
    set cacheNetbiosName(value: string);
    get cacheNetbiosNameInput(): string | undefined;
    private _dnsPrimaryIp?;
    get dnsPrimaryIp(): string;
    set dnsPrimaryIp(value: string);
    get dnsPrimaryIpInput(): string | undefined;
    private _dnsSecondaryIp?;
    get dnsSecondaryIp(): string;
    set dnsSecondaryIp(value: string);
    resetDnsSecondaryIp(): void;
    get dnsSecondaryIpInput(): string | undefined;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    private _domainNetbiosName?;
    get domainNetbiosName(): string;
    set domainNetbiosName(value: string);
    get domainNetbiosNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface HpcCacheDirectoryFlatFile {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#group_file_uri HpcCache#group_file_uri}
    */
    readonly groupFileUri: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#password_file_uri HpcCache#password_file_uri}
    */
    readonly passwordFileUri: string;
}
export declare function hpcCacheDirectoryFlatFileToTerraform(struct?: HpcCacheDirectoryFlatFileOutputReference | HpcCacheDirectoryFlatFile): any;
export declare class HpcCacheDirectoryFlatFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HpcCacheDirectoryFlatFile | undefined;
    set internalValue(value: HpcCacheDirectoryFlatFile | undefined);
    private _groupFileUri?;
    get groupFileUri(): string;
    set groupFileUri(value: string);
    get groupFileUriInput(): string | undefined;
    private _passwordFileUri?;
    get passwordFileUri(): string;
    set passwordFileUri(value: string);
    get passwordFileUriInput(): string | undefined;
}
export interface HpcCacheDirectoryLdapBind {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#dn HpcCache#dn}
    */
    readonly dn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#password HpcCache#password}
    */
    readonly password: string;
}
export declare function hpcCacheDirectoryLdapBindToTerraform(struct?: HpcCacheDirectoryLdapBindOutputReference | HpcCacheDirectoryLdapBind): any;
export declare class HpcCacheDirectoryLdapBindOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HpcCacheDirectoryLdapBind | undefined;
    set internalValue(value: HpcCacheDirectoryLdapBind | undefined);
    private _dn?;
    get dn(): string;
    set dn(value: string);
    get dnInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
}
export interface HpcCacheDirectoryLdap {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#base_dn HpcCache#base_dn}
    */
    readonly baseDn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#certificate_validation_uri HpcCache#certificate_validation_uri}
    */
    readonly certificateValidationUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#download_certificate_automatically HpcCache#download_certificate_automatically}
    */
    readonly downloadCertificateAutomatically?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#encrypted HpcCache#encrypted}
    */
    readonly encrypted?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#server HpcCache#server}
    */
    readonly server: string;
    /**
    * bind block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#bind HpcCache#bind}
    */
    readonly bind?: HpcCacheDirectoryLdapBind;
}
export declare function hpcCacheDirectoryLdapToTerraform(struct?: HpcCacheDirectoryLdapOutputReference | HpcCacheDirectoryLdap): any;
export declare class HpcCacheDirectoryLdapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HpcCacheDirectoryLdap | undefined;
    set internalValue(value: HpcCacheDirectoryLdap | undefined);
    private _baseDn?;
    get baseDn(): string;
    set baseDn(value: string);
    get baseDnInput(): string | undefined;
    private _certificateValidationUri?;
    get certificateValidationUri(): string;
    set certificateValidationUri(value: string);
    resetCertificateValidationUri(): void;
    get certificateValidationUriInput(): string | undefined;
    private _downloadCertificateAutomatically?;
    get downloadCertificateAutomatically(): boolean | cdktf.IResolvable;
    set downloadCertificateAutomatically(value: boolean | cdktf.IResolvable);
    resetDownloadCertificateAutomatically(): void;
    get downloadCertificateAutomaticallyInput(): boolean | cdktf.IResolvable | undefined;
    private _encrypted?;
    get encrypted(): boolean | cdktf.IResolvable;
    set encrypted(value: boolean | cdktf.IResolvable);
    resetEncrypted(): void;
    get encryptedInput(): boolean | cdktf.IResolvable | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _bind;
    get bind(): HpcCacheDirectoryLdapBindOutputReference;
    putBind(value: HpcCacheDirectoryLdapBind): void;
    resetBind(): void;
    get bindInput(): HpcCacheDirectoryLdapBind | undefined;
}
export interface HpcCacheDns {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#search_domain HpcCache#search_domain}
    */
    readonly searchDomain?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#servers HpcCache#servers}
    */
    readonly servers: string[];
}
export declare function hpcCacheDnsToTerraform(struct?: HpcCacheDnsOutputReference | HpcCacheDns): any;
export declare class HpcCacheDnsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HpcCacheDns | undefined;
    set internalValue(value: HpcCacheDns | undefined);
    private _searchDomain?;
    get searchDomain(): string;
    set searchDomain(value: string);
    resetSearchDomain(): void;
    get searchDomainInput(): string | undefined;
    private _servers?;
    get servers(): string[];
    set servers(value: string[]);
    get serversInput(): string[] | undefined;
}
export interface HpcCacheTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#create HpcCache#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#delete HpcCache#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#read HpcCache#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache#update HpcCache#update}
    */
    readonly update?: string;
}
export declare function hpcCacheTimeoutsToTerraform(struct?: HpcCacheTimeoutsOutputReference | HpcCacheTimeouts | cdktf.IResolvable): any;
export declare class HpcCacheTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HpcCacheTimeouts | undefined;
    set internalValue(value: HpcCacheTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache azurerm_hpc_cache}
*/
export declare class HpcCache extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache azurerm_hpc_cache} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HpcCacheConfig
    */
    constructor(scope: Construct, id: string, config: HpcCacheConfig);
    private _cacheSizeInGb?;
    get cacheSizeInGb(): number;
    set cacheSizeInGb(value: number);
    get cacheSizeInGbInput(): number | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get mountAddresses(): string[];
    private _mtu?;
    get mtu(): number;
    set mtu(value: number);
    resetMtu(): void;
    get mtuInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ntpServer?;
    get ntpServer(): string;
    set ntpServer(value: string);
    resetNtpServer(): void;
    get ntpServerInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _rootSquashEnabled?;
    get rootSquashEnabled(): boolean | cdktf.IResolvable;
    set rootSquashEnabled(value: boolean | cdktf.IResolvable);
    resetRootSquashEnabled(): void;
    get rootSquashEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _defaultAccessPolicy;
    get defaultAccessPolicy(): HpcCacheDefaultAccessPolicyOutputReference;
    putDefaultAccessPolicy(value: HpcCacheDefaultAccessPolicy): void;
    resetDefaultAccessPolicy(): void;
    get defaultAccessPolicyInput(): HpcCacheDefaultAccessPolicy | undefined;
    private _directoryActiveDirectory;
    get directoryActiveDirectory(): HpcCacheDirectoryActiveDirectoryOutputReference;
    putDirectoryActiveDirectory(value: HpcCacheDirectoryActiveDirectory): void;
    resetDirectoryActiveDirectory(): void;
    get directoryActiveDirectoryInput(): HpcCacheDirectoryActiveDirectory | undefined;
    private _directoryFlatFile;
    get directoryFlatFile(): HpcCacheDirectoryFlatFileOutputReference;
    putDirectoryFlatFile(value: HpcCacheDirectoryFlatFile): void;
    resetDirectoryFlatFile(): void;
    get directoryFlatFileInput(): HpcCacheDirectoryFlatFile | undefined;
    private _directoryLdap;
    get directoryLdap(): HpcCacheDirectoryLdapOutputReference;
    putDirectoryLdap(value: HpcCacheDirectoryLdap): void;
    resetDirectoryLdap(): void;
    get directoryLdapInput(): HpcCacheDirectoryLdap | undefined;
    private _dns;
    get dns(): HpcCacheDnsOutputReference;
    putDns(value: HpcCacheDns): void;
    resetDns(): void;
    get dnsInput(): HpcCacheDns | undefined;
    private _timeouts;
    get timeouts(): HpcCacheTimeoutsOutputReference;
    putTimeouts(value: HpcCacheTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): HpcCacheTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
