import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IotSecuritySolutionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#disabled_data_sources IotSecuritySolution#disabled_data_sources}
    */
    readonly disabledDataSources?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#display_name IotSecuritySolution#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#enabled IotSecuritySolution#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#events_to_export IotSecuritySolution#events_to_export}
    */
    readonly eventsToExport?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#iothub_ids IotSecuritySolution#iothub_ids}
    */
    readonly iothubIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#location IotSecuritySolution#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#log_analytics_workspace_id IotSecuritySolution#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#log_unmasked_ips_enabled IotSecuritySolution#log_unmasked_ips_enabled}
    */
    readonly logUnmaskedIpsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#name IotSecuritySolution#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#query_for_resources IotSecuritySolution#query_for_resources}
    */
    readonly queryForResources?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#query_subscription_ids IotSecuritySolution#query_subscription_ids}
    */
    readonly querySubscriptionIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#resource_group_name IotSecuritySolution#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#tags IotSecuritySolution#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * additional_workspace block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#additional_workspace IotSecuritySolution#additional_workspace}
    */
    readonly additionalWorkspace?: IotSecuritySolutionAdditionalWorkspace[] | cdktf.IResolvable;
    /**
    * recommendations_enabled block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#recommendations_enabled IotSecuritySolution#recommendations_enabled}
    */
    readonly recommendationsEnabled?: IotSecuritySolutionRecommendationsEnabled;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#timeouts IotSecuritySolution#timeouts}
    */
    readonly timeouts?: IotSecuritySolutionTimeouts;
}
export interface IotSecuritySolutionAdditionalWorkspace {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#data_types IotSecuritySolution#data_types}
    */
    readonly dataTypes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#workspace_id IotSecuritySolution#workspace_id}
    */
    readonly workspaceId: string;
}
export declare function iotSecuritySolutionAdditionalWorkspaceToTerraform(struct?: IotSecuritySolutionAdditionalWorkspace | cdktf.IResolvable): any;
export interface IotSecuritySolutionRecommendationsEnabled {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#acr_authentication IotSecuritySolution#acr_authentication}
    */
    readonly acrAuthentication?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#agent_send_unutilized_msg IotSecuritySolution#agent_send_unutilized_msg}
    */
    readonly agentSendUnutilizedMsg?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#baseline IotSecuritySolution#baseline}
    */
    readonly baseline?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#edge_hub_mem_optimize IotSecuritySolution#edge_hub_mem_optimize}
    */
    readonly edgeHubMemOptimize?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#edge_logging_option IotSecuritySolution#edge_logging_option}
    */
    readonly edgeLoggingOption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#inconsistent_module_settings IotSecuritySolution#inconsistent_module_settings}
    */
    readonly inconsistentModuleSettings?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#install_agent IotSecuritySolution#install_agent}
    */
    readonly installAgent?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#ip_filter_deny_all IotSecuritySolution#ip_filter_deny_all}
    */
    readonly ipFilterDenyAll?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#ip_filter_permissive_rule IotSecuritySolution#ip_filter_permissive_rule}
    */
    readonly ipFilterPermissiveRule?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#open_ports IotSecuritySolution#open_ports}
    */
    readonly openPorts?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#permissive_firewall_policy IotSecuritySolution#permissive_firewall_policy}
    */
    readonly permissiveFirewallPolicy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#permissive_input_firewall_rules IotSecuritySolution#permissive_input_firewall_rules}
    */
    readonly permissiveInputFirewallRules?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#permissive_output_firewall_rules IotSecuritySolution#permissive_output_firewall_rules}
    */
    readonly permissiveOutputFirewallRules?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#privileged_docker_options IotSecuritySolution#privileged_docker_options}
    */
    readonly privilegedDockerOptions?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#shared_credentials IotSecuritySolution#shared_credentials}
    */
    readonly sharedCredentials?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#vulnerable_tls_cipher_suite IotSecuritySolution#vulnerable_tls_cipher_suite}
    */
    readonly vulnerableTlsCipherSuite?: boolean | cdktf.IResolvable;
}
export declare function iotSecuritySolutionRecommendationsEnabledToTerraform(struct?: IotSecuritySolutionRecommendationsEnabledOutputReference | IotSecuritySolutionRecommendationsEnabled): any;
export declare class IotSecuritySolutionRecommendationsEnabledOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): IotSecuritySolutionRecommendationsEnabled | undefined;
    set internalValue(value: IotSecuritySolutionRecommendationsEnabled | undefined);
    private _acrAuthentication?;
    get acrAuthentication(): boolean | cdktf.IResolvable;
    set acrAuthentication(value: boolean | cdktf.IResolvable);
    resetAcrAuthentication(): void;
    get acrAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _agentSendUnutilizedMsg?;
    get agentSendUnutilizedMsg(): boolean | cdktf.IResolvable;
    set agentSendUnutilizedMsg(value: boolean | cdktf.IResolvable);
    resetAgentSendUnutilizedMsg(): void;
    get agentSendUnutilizedMsgInput(): boolean | cdktf.IResolvable | undefined;
    private _baseline?;
    get baseline(): boolean | cdktf.IResolvable;
    set baseline(value: boolean | cdktf.IResolvable);
    resetBaseline(): void;
    get baselineInput(): boolean | cdktf.IResolvable | undefined;
    private _edgeHubMemOptimize?;
    get edgeHubMemOptimize(): boolean | cdktf.IResolvable;
    set edgeHubMemOptimize(value: boolean | cdktf.IResolvable);
    resetEdgeHubMemOptimize(): void;
    get edgeHubMemOptimizeInput(): boolean | cdktf.IResolvable | undefined;
    private _edgeLoggingOption?;
    get edgeLoggingOption(): boolean | cdktf.IResolvable;
    set edgeLoggingOption(value: boolean | cdktf.IResolvable);
    resetEdgeLoggingOption(): void;
    get edgeLoggingOptionInput(): boolean | cdktf.IResolvable | undefined;
    private _inconsistentModuleSettings?;
    get inconsistentModuleSettings(): boolean | cdktf.IResolvable;
    set inconsistentModuleSettings(value: boolean | cdktf.IResolvable);
    resetInconsistentModuleSettings(): void;
    get inconsistentModuleSettingsInput(): boolean | cdktf.IResolvable | undefined;
    private _installAgent?;
    get installAgent(): boolean | cdktf.IResolvable;
    set installAgent(value: boolean | cdktf.IResolvable);
    resetInstallAgent(): void;
    get installAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _ipFilterDenyAll?;
    get ipFilterDenyAll(): boolean | cdktf.IResolvable;
    set ipFilterDenyAll(value: boolean | cdktf.IResolvable);
    resetIpFilterDenyAll(): void;
    get ipFilterDenyAllInput(): boolean | cdktf.IResolvable | undefined;
    private _ipFilterPermissiveRule?;
    get ipFilterPermissiveRule(): boolean | cdktf.IResolvable;
    set ipFilterPermissiveRule(value: boolean | cdktf.IResolvable);
    resetIpFilterPermissiveRule(): void;
    get ipFilterPermissiveRuleInput(): boolean | cdktf.IResolvable | undefined;
    private _openPorts?;
    get openPorts(): boolean | cdktf.IResolvable;
    set openPorts(value: boolean | cdktf.IResolvable);
    resetOpenPorts(): void;
    get openPortsInput(): boolean | cdktf.IResolvable | undefined;
    private _permissiveFirewallPolicy?;
    get permissiveFirewallPolicy(): boolean | cdktf.IResolvable;
    set permissiveFirewallPolicy(value: boolean | cdktf.IResolvable);
    resetPermissiveFirewallPolicy(): void;
    get permissiveFirewallPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _permissiveInputFirewallRules?;
    get permissiveInputFirewallRules(): boolean | cdktf.IResolvable;
    set permissiveInputFirewallRules(value: boolean | cdktf.IResolvable);
    resetPermissiveInputFirewallRules(): void;
    get permissiveInputFirewallRulesInput(): boolean | cdktf.IResolvable | undefined;
    private _permissiveOutputFirewallRules?;
    get permissiveOutputFirewallRules(): boolean | cdktf.IResolvable;
    set permissiveOutputFirewallRules(value: boolean | cdktf.IResolvable);
    resetPermissiveOutputFirewallRules(): void;
    get permissiveOutputFirewallRulesInput(): boolean | cdktf.IResolvable | undefined;
    private _privilegedDockerOptions?;
    get privilegedDockerOptions(): boolean | cdktf.IResolvable;
    set privilegedDockerOptions(value: boolean | cdktf.IResolvable);
    resetPrivilegedDockerOptions(): void;
    get privilegedDockerOptionsInput(): boolean | cdktf.IResolvable | undefined;
    private _sharedCredentials?;
    get sharedCredentials(): boolean | cdktf.IResolvable;
    set sharedCredentials(value: boolean | cdktf.IResolvable);
    resetSharedCredentials(): void;
    get sharedCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _vulnerableTlsCipherSuite?;
    get vulnerableTlsCipherSuite(): boolean | cdktf.IResolvable;
    set vulnerableTlsCipherSuite(value: boolean | cdktf.IResolvable);
    resetVulnerableTlsCipherSuite(): void;
    get vulnerableTlsCipherSuiteInput(): boolean | cdktf.IResolvable | undefined;
}
export interface IotSecuritySolutionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#create IotSecuritySolution#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#delete IotSecuritySolution#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#read IotSecuritySolution#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution#update IotSecuritySolution#update}
    */
    readonly update?: string;
}
export declare function iotSecuritySolutionTimeoutsToTerraform(struct?: IotSecuritySolutionTimeoutsOutputReference | IotSecuritySolutionTimeouts | cdktf.IResolvable): any;
export declare class IotSecuritySolutionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): IotSecuritySolutionTimeouts | undefined;
    set internalValue(value: IotSecuritySolutionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution azurerm_iot_security_solution}
*/
export declare class IotSecuritySolution extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iot_security_solution azurerm_iot_security_solution} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IotSecuritySolutionConfig
    */
    constructor(scope: Construct, id: string, config: IotSecuritySolutionConfig);
    private _disabledDataSources?;
    get disabledDataSources(): string[];
    set disabledDataSources(value: string[]);
    resetDisabledDataSources(): void;
    get disabledDataSourcesInput(): string[] | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _eventsToExport?;
    get eventsToExport(): string[];
    set eventsToExport(value: string[]);
    resetEventsToExport(): void;
    get eventsToExportInput(): string[] | undefined;
    get id(): string;
    private _iothubIds?;
    get iothubIds(): string[];
    set iothubIds(value: string[]);
    get iothubIdsInput(): string[] | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    resetLogAnalyticsWorkspaceId(): void;
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _logUnmaskedIpsEnabled?;
    get logUnmaskedIpsEnabled(): boolean | cdktf.IResolvable;
    set logUnmaskedIpsEnabled(value: boolean | cdktf.IResolvable);
    resetLogUnmaskedIpsEnabled(): void;
    get logUnmaskedIpsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _queryForResources?;
    get queryForResources(): string;
    set queryForResources(value: string);
    resetQueryForResources(): void;
    get queryForResourcesInput(): string | undefined;
    private _querySubscriptionIds?;
    get querySubscriptionIds(): string[];
    set querySubscriptionIds(value: string[]);
    resetQuerySubscriptionIds(): void;
    get querySubscriptionIdsInput(): string[] | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _additionalWorkspace?;
    get additionalWorkspace(): IotSecuritySolutionAdditionalWorkspace[] | cdktf.IResolvable;
    set additionalWorkspace(value: IotSecuritySolutionAdditionalWorkspace[] | cdktf.IResolvable);
    resetAdditionalWorkspace(): void;
    get additionalWorkspaceInput(): cdktf.IResolvable | IotSecuritySolutionAdditionalWorkspace[] | undefined;
    private _recommendationsEnabled;
    get recommendationsEnabled(): IotSecuritySolutionRecommendationsEnabledOutputReference;
    putRecommendationsEnabled(value: IotSecuritySolutionRecommendationsEnabled): void;
    resetRecommendationsEnabled(): void;
    get recommendationsEnabledInput(): IotSecuritySolutionRecommendationsEnabled | undefined;
    private _timeouts;
    get timeouts(): IotSecuritySolutionTimeoutsOutputReference;
    putTimeouts(value: IotSecuritySolutionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): IotSecuritySolutionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
