import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IothubCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_certificate#certificate_content IothubCertificate#certificate_content}
    */
    readonly certificateContent: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_certificate#iothub_name IothubCertificate#iothub_name}
    */
    readonly iothubName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_certificate#is_verified IothubCertificate#is_verified}
    */
    readonly isVerified?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_certificate#name IothubCertificate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_certificate#resource_group_name IothubCertificate#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_certificate#timeouts IothubCertificate#timeouts}
    */
    readonly timeouts?: IothubCertificateTimeouts;
}
export interface IothubCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_certificate#create IothubCertificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_certificate#delete IothubCertificate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_certificate#read IothubCertificate#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_certificate#update IothubCertificate#update}
    */
    readonly update?: string;
}
export declare function iothubCertificateTimeoutsToTerraform(struct?: IothubCertificateTimeoutsOutputReference | IothubCertificateTimeouts | cdktf.IResolvable): any;
export declare class IothubCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): IothubCertificateTimeouts | undefined;
    set internalValue(value: IothubCertificateTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_certificate azurerm_iothub_certificate}
*/
export declare class IothubCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_certificate azurerm_iothub_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IothubCertificateConfig
    */
    constructor(scope: Construct, id: string, config: IothubCertificateConfig);
    private _certificateContent?;
    get certificateContent(): string;
    set certificateContent(value: string);
    get certificateContentInput(): string | undefined;
    get id(): string;
    private _iothubName?;
    get iothubName(): string;
    set iothubName(value: string);
    get iothubNameInput(): string | undefined;
    private _isVerified?;
    get isVerified(): boolean | cdktf.IResolvable;
    set isVerified(value: boolean | cdktf.IResolvable);
    resetIsVerified(): void;
    get isVerifiedInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): IothubCertificateTimeoutsOutputReference;
    putTimeouts(value: IothubCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): IothubCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
