import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KustoScriptConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script#continue_on_errors_enabled KustoScript#continue_on_errors_enabled}
    */
    readonly continueOnErrorsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script#database_id KustoScript#database_id}
    */
    readonly databaseId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script#force_an_update_when_value_changed KustoScript#force_an_update_when_value_changed}
    */
    readonly forceAnUpdateWhenValueChanged?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script#name KustoScript#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script#sas_token KustoScript#sas_token}
    */
    readonly sasToken: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script#url KustoScript#url}
    */
    readonly url: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script#timeouts KustoScript#timeouts}
    */
    readonly timeouts?: KustoScriptTimeouts;
}
export interface KustoScriptTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script#create KustoScript#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script#delete KustoScript#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script#read KustoScript#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script#update KustoScript#update}
    */
    readonly update?: string;
}
export declare function kustoScriptTimeoutsToTerraform(struct?: KustoScriptTimeoutsOutputReference | KustoScriptTimeouts | cdktf.IResolvable): any;
export declare class KustoScriptTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): KustoScriptTimeouts | undefined;
    set internalValue(value: KustoScriptTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script azurerm_kusto_script}
*/
export declare class KustoScript extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_script azurerm_kusto_script} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KustoScriptConfig
    */
    constructor(scope: Construct, id: string, config: KustoScriptConfig);
    private _continueOnErrorsEnabled?;
    get continueOnErrorsEnabled(): boolean | cdktf.IResolvable;
    set continueOnErrorsEnabled(value: boolean | cdktf.IResolvable);
    resetContinueOnErrorsEnabled(): void;
    get continueOnErrorsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _databaseId?;
    get databaseId(): string;
    set databaseId(value: string);
    get databaseIdInput(): string | undefined;
    private _forceAnUpdateWhenValueChanged?;
    get forceAnUpdateWhenValueChanged(): string;
    set forceAnUpdateWhenValueChanged(value: string);
    resetForceAnUpdateWhenValueChanged(): void;
    get forceAnUpdateWhenValueChangedInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sasToken?;
    get sasToken(): string;
    set sasToken(value: string);
    get sasTokenInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _timeouts;
    get timeouts(): KustoScriptTimeoutsOutputReference;
    putTimeouts(value: KustoScriptTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): KustoScriptTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
