import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#backend_address_pool_id LbRule#backend_address_pool_id}
    */
    readonly backendAddressPoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#backend_address_pool_ids LbRule#backend_address_pool_ids}
    */
    readonly backendAddressPoolIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#backend_port LbRule#backend_port}
    */
    readonly backendPort: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#disable_outbound_snat LbRule#disable_outbound_snat}
    */
    readonly disableOutboundSnat?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#enable_floating_ip LbRule#enable_floating_ip}
    */
    readonly enableFloatingIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#enable_tcp_reset LbRule#enable_tcp_reset}
    */
    readonly enableTcpReset?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#frontend_ip_configuration_name LbRule#frontend_ip_configuration_name}
    */
    readonly frontendIpConfigurationName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#frontend_port LbRule#frontend_port}
    */
    readonly frontendPort: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#idle_timeout_in_minutes LbRule#idle_timeout_in_minutes}
    */
    readonly idleTimeoutInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#load_distribution LbRule#load_distribution}
    */
    readonly loadDistribution?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#loadbalancer_id LbRule#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#name LbRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#probe_id LbRule#probe_id}
    */
    readonly probeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#protocol LbRule#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#resource_group_name LbRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#timeouts LbRule#timeouts}
    */
    readonly timeouts?: LbRuleTimeouts;
}
export interface LbRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#create LbRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#delete LbRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#read LbRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule#update LbRule#update}
    */
    readonly update?: string;
}
export declare function lbRuleTimeoutsToTerraform(struct?: LbRuleTimeoutsOutputReference | LbRuleTimeouts | cdktf.IResolvable): any;
export declare class LbRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): LbRuleTimeouts | undefined;
    set internalValue(value: LbRuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule azurerm_lb_rule}
*/
export declare class LbRule extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/lb_rule azurerm_lb_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbRuleConfig
    */
    constructor(scope: Construct, id: string, config: LbRuleConfig);
    private _backendAddressPoolId?;
    get backendAddressPoolId(): string;
    set backendAddressPoolId(value: string);
    resetBackendAddressPoolId(): void;
    get backendAddressPoolIdInput(): string | undefined;
    private _backendAddressPoolIds?;
    get backendAddressPoolIds(): string[];
    set backendAddressPoolIds(value: string[]);
    resetBackendAddressPoolIds(): void;
    get backendAddressPoolIdsInput(): string[] | undefined;
    private _backendPort?;
    get backendPort(): number;
    set backendPort(value: number);
    get backendPortInput(): number | undefined;
    private _disableOutboundSnat?;
    get disableOutboundSnat(): boolean | cdktf.IResolvable;
    set disableOutboundSnat(value: boolean | cdktf.IResolvable);
    resetDisableOutboundSnat(): void;
    get disableOutboundSnatInput(): boolean | cdktf.IResolvable | undefined;
    private _enableFloatingIp?;
    get enableFloatingIp(): boolean | cdktf.IResolvable;
    set enableFloatingIp(value: boolean | cdktf.IResolvable);
    resetEnableFloatingIp(): void;
    get enableFloatingIpInput(): boolean | cdktf.IResolvable | undefined;
    private _enableTcpReset?;
    get enableTcpReset(): boolean | cdktf.IResolvable;
    set enableTcpReset(value: boolean | cdktf.IResolvable);
    resetEnableTcpReset(): void;
    get enableTcpResetInput(): boolean | cdktf.IResolvable | undefined;
    get frontendIpConfigurationId(): string;
    private _frontendIpConfigurationName?;
    get frontendIpConfigurationName(): string;
    set frontendIpConfigurationName(value: string);
    get frontendIpConfigurationNameInput(): string | undefined;
    private _frontendPort?;
    get frontendPort(): number;
    set frontendPort(value: number);
    get frontendPortInput(): number | undefined;
    get id(): string;
    private _idleTimeoutInMinutes?;
    get idleTimeoutInMinutes(): number;
    set idleTimeoutInMinutes(value: number);
    resetIdleTimeoutInMinutes(): void;
    get idleTimeoutInMinutesInput(): number | undefined;
    private _loadDistribution?;
    get loadDistribution(): string;
    set loadDistribution(value: string);
    resetLoadDistribution(): void;
    get loadDistributionInput(): string | undefined;
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _probeId?;
    get probeId(): string;
    set probeId(value: string);
    resetProbeId(): void;
    get probeIdInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): LbRuleTimeoutsOutputReference;
    putTimeouts(value: LbRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): LbRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
