import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagementGroupTemplateDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_template_deployment#debug_level ManagementGroupTemplateDeployment#debug_level}
    */
    readonly debugLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_template_deployment#location ManagementGroupTemplateDeployment#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_template_deployment#management_group_id ManagementGroupTemplateDeployment#management_group_id}
    */
    readonly managementGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_template_deployment#name ManagementGroupTemplateDeployment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_template_deployment#parameters_content ManagementGroupTemplateDeployment#parameters_content}
    */
    readonly parametersContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_template_deployment#tags ManagementGroupTemplateDeployment#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_template_deployment#template_content ManagementGroupTemplateDeployment#template_content}
    */
    readonly templateContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_template_deployment#template_spec_version_id ManagementGroupTemplateDeployment#template_spec_version_id}
    */
    readonly templateSpecVersionId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_template_deployment#timeouts ManagementGroupTemplateDeployment#timeouts}
    */
    readonly timeouts?: ManagementGroupTemplateDeploymentTimeouts;
}
export interface ManagementGroupTemplateDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_template_deployment#create ManagementGroupTemplateDeployment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_template_deployment#delete ManagementGroupTemplateDeployment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_template_deployment#read ManagementGroupTemplateDeployment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_template_deployment#update ManagementGroupTemplateDeployment#update}
    */
    readonly update?: string;
}
export declare function managementGroupTemplateDeploymentTimeoutsToTerraform(struct?: ManagementGroupTemplateDeploymentTimeoutsOutputReference | ManagementGroupTemplateDeploymentTimeouts | cdktf.IResolvable): any;
export declare class ManagementGroupTemplateDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ManagementGroupTemplateDeploymentTimeouts | undefined;
    set internalValue(value: ManagementGroupTemplateDeploymentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_template_deployment azurerm_management_group_template_deployment}
*/
export declare class ManagementGroupTemplateDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/management_group_template_deployment azurerm_management_group_template_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagementGroupTemplateDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: ManagementGroupTemplateDeploymentConfig);
    private _debugLevel?;
    get debugLevel(): string;
    set debugLevel(value: string);
    resetDebugLevel(): void;
    get debugLevelInput(): string | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _managementGroupId?;
    get managementGroupId(): string;
    set managementGroupId(value: string);
    get managementGroupIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputContent(): string;
    private _parametersContent?;
    get parametersContent(): string;
    set parametersContent(value: string);
    resetParametersContent(): void;
    get parametersContentInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _templateContent?;
    get templateContent(): string;
    set templateContent(value: string);
    resetTemplateContent(): void;
    get templateContentInput(): string | undefined;
    private _templateSpecVersionId?;
    get templateSpecVersionId(): string;
    set templateSpecVersionId(value: string);
    resetTemplateSpecVersionId(): void;
    get templateSpecVersionIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ManagementGroupTemplateDeploymentTimeoutsOutputReference;
    putTimeouts(value: ManagementGroupTemplateDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ManagementGroupTemplateDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
