import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MarketplaceAgreementConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/marketplace_agreement#offer MarketplaceAgreement#offer}
    */
    readonly offer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/marketplace_agreement#plan MarketplaceAgreement#plan}
    */
    readonly plan: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/marketplace_agreement#publisher MarketplaceAgreement#publisher}
    */
    readonly publisher: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/marketplace_agreement#timeouts MarketplaceAgreement#timeouts}
    */
    readonly timeouts?: MarketplaceAgreementTimeouts;
}
export interface MarketplaceAgreementTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/marketplace_agreement#create MarketplaceAgreement#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/marketplace_agreement#delete MarketplaceAgreement#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/marketplace_agreement#read MarketplaceAgreement#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/marketplace_agreement#update MarketplaceAgreement#update}
    */
    readonly update?: string;
}
export declare function marketplaceAgreementTimeoutsToTerraform(struct?: MarketplaceAgreementTimeoutsOutputReference | MarketplaceAgreementTimeouts | cdktf.IResolvable): any;
export declare class MarketplaceAgreementTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): MarketplaceAgreementTimeouts | undefined;
    set internalValue(value: MarketplaceAgreementTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/marketplace_agreement azurerm_marketplace_agreement}
*/
export declare class MarketplaceAgreement extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/marketplace_agreement azurerm_marketplace_agreement} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MarketplaceAgreementConfig
    */
    constructor(scope: Construct, id: string, config: MarketplaceAgreementConfig);
    get id(): string;
    get licenseTextLink(): string;
    private _offer?;
    get offer(): string;
    set offer(value: string);
    get offerInput(): string | undefined;
    private _plan?;
    get plan(): string;
    set plan(value: string);
    get planInput(): string | undefined;
    get privacyPolicyLink(): string;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _timeouts;
    get timeouts(): MarketplaceAgreementTimeoutsOutputReference;
    putTimeouts(value: MarketplaceAgreementTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MarketplaceAgreementTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
