import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlManagedInstanceFailoverGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_failover_group#location MssqlManagedInstanceFailoverGroup#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_failover_group#managed_instance_id MssqlManagedInstanceFailoverGroup#managed_instance_id}
    */
    readonly managedInstanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_failover_group#name MssqlManagedInstanceFailoverGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_failover_group#partner_managed_instance_id MssqlManagedInstanceFailoverGroup#partner_managed_instance_id}
    */
    readonly partnerManagedInstanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_failover_group#readonly_endpoint_failover_policy_enabled MssqlManagedInstanceFailoverGroup#readonly_endpoint_failover_policy_enabled}
    */
    readonly readonlyEndpointFailoverPolicyEnabled?: boolean | cdktf.IResolvable;
    /**
    * read_write_endpoint_failover_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_failover_group#read_write_endpoint_failover_policy MssqlManagedInstanceFailoverGroup#read_write_endpoint_failover_policy}
    */
    readonly readWriteEndpointFailoverPolicy: MssqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_failover_group#timeouts MssqlManagedInstanceFailoverGroup#timeouts}
    */
    readonly timeouts?: MssqlManagedInstanceFailoverGroupTimeouts;
}
export declare class MssqlManagedInstanceFailoverGroupPartnerRegion extends cdktf.ComplexComputedList {
    get location(): string;
    get role(): string;
}
export interface MssqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_failover_group#grace_minutes MssqlManagedInstanceFailoverGroup#grace_minutes}
    */
    readonly graceMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_failover_group#mode MssqlManagedInstanceFailoverGroup#mode}
    */
    readonly mode: string;
}
export declare function mssqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyToTerraform(struct?: MssqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyOutputReference | MssqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy): any;
export declare class MssqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): MssqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy | undefined;
    set internalValue(value: MssqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy | undefined);
    private _graceMinutes?;
    get graceMinutes(): number;
    set graceMinutes(value: number);
    resetGraceMinutes(): void;
    get graceMinutesInput(): number | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
}
export interface MssqlManagedInstanceFailoverGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_failover_group#create MssqlManagedInstanceFailoverGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_failover_group#delete MssqlManagedInstanceFailoverGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_failover_group#read MssqlManagedInstanceFailoverGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_failover_group#update MssqlManagedInstanceFailoverGroup#update}
    */
    readonly update?: string;
}
export declare function mssqlManagedInstanceFailoverGroupTimeoutsToTerraform(struct?: MssqlManagedInstanceFailoverGroupTimeoutsOutputReference | MssqlManagedInstanceFailoverGroupTimeouts | cdktf.IResolvable): any;
export declare class MssqlManagedInstanceFailoverGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): MssqlManagedInstanceFailoverGroupTimeouts | undefined;
    set internalValue(value: MssqlManagedInstanceFailoverGroupTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_failover_group azurerm_mssql_managed_instance_failover_group}
*/
export declare class MssqlManagedInstanceFailoverGroup extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_failover_group azurerm_mssql_managed_instance_failover_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlManagedInstanceFailoverGroupConfig
    */
    constructor(scope: Construct, id: string, config: MssqlManagedInstanceFailoverGroupConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _managedInstanceId?;
    get managedInstanceId(): string;
    set managedInstanceId(value: string);
    get managedInstanceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _partnerManagedInstanceId?;
    get partnerManagedInstanceId(): string;
    set partnerManagedInstanceId(value: string);
    get partnerManagedInstanceIdInput(): string | undefined;
    partnerRegion(index: string): MssqlManagedInstanceFailoverGroupPartnerRegion;
    private _readonlyEndpointFailoverPolicyEnabled?;
    get readonlyEndpointFailoverPolicyEnabled(): boolean | cdktf.IResolvable;
    set readonlyEndpointFailoverPolicyEnabled(value: boolean | cdktf.IResolvable);
    resetReadonlyEndpointFailoverPolicyEnabled(): void;
    get readonlyEndpointFailoverPolicyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get role(): string;
    private _readWriteEndpointFailoverPolicy;
    get readWriteEndpointFailoverPolicy(): MssqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyOutputReference;
    putReadWriteEndpointFailoverPolicy(value: MssqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy): void;
    get readWriteEndpointFailoverPolicyInput(): MssqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy | undefined;
    private _timeouts;
    get timeouts(): MssqlManagedInstanceFailoverGroupTimeoutsOutputReference;
    putTimeouts(value: MssqlManagedInstanceFailoverGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MssqlManagedInstanceFailoverGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
