import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlServerSecurityAlertPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy#disabled_alerts MssqlServerSecurityAlertPolicy#disabled_alerts}
    */
    readonly disabledAlerts?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy#email_account_admins MssqlServerSecurityAlertPolicy#email_account_admins}
    */
    readonly emailAccountAdmins?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy#email_addresses MssqlServerSecurityAlertPolicy#email_addresses}
    */
    readonly emailAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy#resource_group_name MssqlServerSecurityAlertPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy#retention_days MssqlServerSecurityAlertPolicy#retention_days}
    */
    readonly retentionDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy#server_name MssqlServerSecurityAlertPolicy#server_name}
    */
    readonly serverName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy#state MssqlServerSecurityAlertPolicy#state}
    */
    readonly state: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy#storage_account_access_key MssqlServerSecurityAlertPolicy#storage_account_access_key}
    */
    readonly storageAccountAccessKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy#storage_endpoint MssqlServerSecurityAlertPolicy#storage_endpoint}
    */
    readonly storageEndpoint?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy#timeouts MssqlServerSecurityAlertPolicy#timeouts}
    */
    readonly timeouts?: MssqlServerSecurityAlertPolicyTimeouts;
}
export interface MssqlServerSecurityAlertPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy#create MssqlServerSecurityAlertPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy#delete MssqlServerSecurityAlertPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy#read MssqlServerSecurityAlertPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy#update MssqlServerSecurityAlertPolicy#update}
    */
    readonly update?: string;
}
export declare function mssqlServerSecurityAlertPolicyTimeoutsToTerraform(struct?: MssqlServerSecurityAlertPolicyTimeoutsOutputReference | MssqlServerSecurityAlertPolicyTimeouts | cdktf.IResolvable): any;
export declare class MssqlServerSecurityAlertPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): MssqlServerSecurityAlertPolicyTimeouts | undefined;
    set internalValue(value: MssqlServerSecurityAlertPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy azurerm_mssql_server_security_alert_policy}
*/
export declare class MssqlServerSecurityAlertPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server_security_alert_policy azurerm_mssql_server_security_alert_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlServerSecurityAlertPolicyConfig
    */
    constructor(scope: Construct, id: string, config: MssqlServerSecurityAlertPolicyConfig);
    private _disabledAlerts?;
    get disabledAlerts(): string[];
    set disabledAlerts(value: string[]);
    resetDisabledAlerts(): void;
    get disabledAlertsInput(): string[] | undefined;
    private _emailAccountAdmins?;
    get emailAccountAdmins(): boolean | cdktf.IResolvable;
    set emailAccountAdmins(value: boolean | cdktf.IResolvable);
    resetEmailAccountAdmins(): void;
    get emailAccountAdminsInput(): boolean | cdktf.IResolvable | undefined;
    private _emailAddresses?;
    get emailAddresses(): string[];
    set emailAddresses(value: string[]);
    resetEmailAddresses(): void;
    get emailAddressesInput(): string[] | undefined;
    get id(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _retentionDays?;
    get retentionDays(): number;
    set retentionDays(value: number);
    resetRetentionDays(): void;
    get retentionDaysInput(): number | undefined;
    private _serverName?;
    get serverName(): string;
    set serverName(value: string);
    get serverNameInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    get stateInput(): string | undefined;
    private _storageAccountAccessKey?;
    get storageAccountAccessKey(): string;
    set storageAccountAccessKey(value: string);
    resetStorageAccountAccessKey(): void;
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageEndpoint?;
    get storageEndpoint(): string;
    set storageEndpoint(value: string);
    resetStorageEndpoint(): void;
    get storageEndpointInput(): string | undefined;
    private _timeouts;
    get timeouts(): MssqlServerSecurityAlertPolicyTimeoutsOutputReference;
    putTimeouts(value: MssqlServerSecurityAlertPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MssqlServerSecurityAlertPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
