import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PacketCaptureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#maximum_bytes_per_packet PacketCapture#maximum_bytes_per_packet}
    */
    readonly maximumBytesPerPacket?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#maximum_bytes_per_session PacketCapture#maximum_bytes_per_session}
    */
    readonly maximumBytesPerSession?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#maximum_capture_duration PacketCapture#maximum_capture_duration}
    */
    readonly maximumCaptureDuration?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#name PacketCapture#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#network_watcher_name PacketCapture#network_watcher_name}
    */
    readonly networkWatcherName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#resource_group_name PacketCapture#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#target_resource_id PacketCapture#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#filter PacketCapture#filter}
    */
    readonly filter?: PacketCaptureFilter[] | cdktf.IResolvable;
    /**
    * storage_location block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#storage_location PacketCapture#storage_location}
    */
    readonly storageLocation: PacketCaptureStorageLocation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#timeouts PacketCapture#timeouts}
    */
    readonly timeouts?: PacketCaptureTimeouts;
}
export interface PacketCaptureFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#local_ip_address PacketCapture#local_ip_address}
    */
    readonly localIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#local_port PacketCapture#local_port}
    */
    readonly localPort?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#protocol PacketCapture#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#remote_ip_address PacketCapture#remote_ip_address}
    */
    readonly remoteIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#remote_port PacketCapture#remote_port}
    */
    readonly remotePort?: string;
}
export declare function packetCaptureFilterToTerraform(struct?: PacketCaptureFilter | cdktf.IResolvable): any;
export interface PacketCaptureStorageLocation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#file_path PacketCapture#file_path}
    */
    readonly filePath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#storage_account_id PacketCapture#storage_account_id}
    */
    readonly storageAccountId?: string;
}
export declare function packetCaptureStorageLocationToTerraform(struct?: PacketCaptureStorageLocationOutputReference | PacketCaptureStorageLocation): any;
export declare class PacketCaptureStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): PacketCaptureStorageLocation | undefined;
    set internalValue(value: PacketCaptureStorageLocation | undefined);
    private _filePath?;
    get filePath(): string;
    set filePath(value: string);
    resetFilePath(): void;
    get filePathInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    get storagePath(): string;
}
export interface PacketCaptureTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#create PacketCapture#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#delete PacketCapture#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#read PacketCapture#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture#update PacketCapture#update}
    */
    readonly update?: string;
}
export declare function packetCaptureTimeoutsToTerraform(struct?: PacketCaptureTimeoutsOutputReference | PacketCaptureTimeouts | cdktf.IResolvable): any;
export declare class PacketCaptureTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): PacketCaptureTimeouts | undefined;
    set internalValue(value: PacketCaptureTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture azurerm_packet_capture}
*/
export declare class PacketCapture extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/packet_capture azurerm_packet_capture} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PacketCaptureConfig
    */
    constructor(scope: Construct, id: string, config: PacketCaptureConfig);
    get id(): string;
    private _maximumBytesPerPacket?;
    get maximumBytesPerPacket(): number;
    set maximumBytesPerPacket(value: number);
    resetMaximumBytesPerPacket(): void;
    get maximumBytesPerPacketInput(): number | undefined;
    private _maximumBytesPerSession?;
    get maximumBytesPerSession(): number;
    set maximumBytesPerSession(value: number);
    resetMaximumBytesPerSession(): void;
    get maximumBytesPerSessionInput(): number | undefined;
    private _maximumCaptureDuration?;
    get maximumCaptureDuration(): number;
    set maximumCaptureDuration(value: number);
    resetMaximumCaptureDuration(): void;
    get maximumCaptureDurationInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkWatcherName?;
    get networkWatcherName(): string;
    set networkWatcherName(value: string);
    get networkWatcherNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _filter?;
    get filter(): PacketCaptureFilter[] | cdktf.IResolvable;
    set filter(value: PacketCaptureFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | PacketCaptureFilter[] | undefined;
    private _storageLocation;
    get storageLocation(): PacketCaptureStorageLocationOutputReference;
    putStorageLocation(value: PacketCaptureStorageLocation): void;
    get storageLocationInput(): PacketCaptureStorageLocation | undefined;
    private _timeouts;
    get timeouts(): PacketCaptureTimeoutsOutputReference;
    putTimeouts(value: PacketCaptureTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): PacketCaptureTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
