import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PostgresqlFlexibleServerDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server_database#charset PostgresqlFlexibleServerDatabase#charset}
    */
    readonly charset?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server_database#collation PostgresqlFlexibleServerDatabase#collation}
    */
    readonly collation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server_database#name PostgresqlFlexibleServerDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server_database#server_id PostgresqlFlexibleServerDatabase#server_id}
    */
    readonly serverId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server_database#timeouts PostgresqlFlexibleServerDatabase#timeouts}
    */
    readonly timeouts?: PostgresqlFlexibleServerDatabaseTimeouts;
}
export interface PostgresqlFlexibleServerDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server_database#create PostgresqlFlexibleServerDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server_database#delete PostgresqlFlexibleServerDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server_database#read PostgresqlFlexibleServerDatabase#read}
    */
    readonly read?: string;
}
export declare function postgresqlFlexibleServerDatabaseTimeoutsToTerraform(struct?: PostgresqlFlexibleServerDatabaseTimeoutsOutputReference | PostgresqlFlexibleServerDatabaseTimeouts | cdktf.IResolvable): any;
export declare class PostgresqlFlexibleServerDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): PostgresqlFlexibleServerDatabaseTimeouts | undefined;
    set internalValue(value: PostgresqlFlexibleServerDatabaseTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server_database azurerm_postgresql_flexible_server_database}
*/
export declare class PostgresqlFlexibleServerDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server_database azurerm_postgresql_flexible_server_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PostgresqlFlexibleServerDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: PostgresqlFlexibleServerDatabaseConfig);
    private _charset?;
    get charset(): string;
    set charset(value: string);
    resetCharset(): void;
    get charsetInput(): string | undefined;
    private _collation?;
    get collation(): string;
    set collation(value: string);
    resetCollation(): void;
    get collationInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _serverId?;
    get serverId(): string;
    set serverId(value: string);
    get serverIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): PostgresqlFlexibleServerDatabaseTimeoutsOutputReference;
    putTimeouts(value: PostgresqlFlexibleServerDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): PostgresqlFlexibleServerDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
