import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivateDnsMxRecordConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_mx_record#name PrivateDnsMxRecord#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_mx_record#resource_group_name PrivateDnsMxRecord#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_mx_record#tags PrivateDnsMxRecord#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_mx_record#ttl PrivateDnsMxRecord#ttl}
    */
    readonly ttl: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_mx_record#zone_name PrivateDnsMxRecord#zone_name}
    */
    readonly zoneName: string;
    /**
    * record block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_mx_record#record PrivateDnsMxRecord#record}
    */
    readonly record: PrivateDnsMxRecordRecord[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_mx_record#timeouts PrivateDnsMxRecord#timeouts}
    */
    readonly timeouts?: PrivateDnsMxRecordTimeouts;
}
export interface PrivateDnsMxRecordRecord {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_mx_record#exchange PrivateDnsMxRecord#exchange}
    */
    readonly exchange: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_mx_record#preference PrivateDnsMxRecord#preference}
    */
    readonly preference: number;
}
export declare function privateDnsMxRecordRecordToTerraform(struct?: PrivateDnsMxRecordRecord | cdktf.IResolvable): any;
export interface PrivateDnsMxRecordTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_mx_record#create PrivateDnsMxRecord#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_mx_record#delete PrivateDnsMxRecord#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_mx_record#read PrivateDnsMxRecord#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_mx_record#update PrivateDnsMxRecord#update}
    */
    readonly update?: string;
}
export declare function privateDnsMxRecordTimeoutsToTerraform(struct?: PrivateDnsMxRecordTimeoutsOutputReference | PrivateDnsMxRecordTimeouts | cdktf.IResolvable): any;
export declare class PrivateDnsMxRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): PrivateDnsMxRecordTimeouts | undefined;
    set internalValue(value: PrivateDnsMxRecordTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_mx_record azurerm_private_dns_mx_record}
*/
export declare class PrivateDnsMxRecord extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_mx_record azurerm_private_dns_mx_record} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivateDnsMxRecordConfig
    */
    constructor(scope: Construct, id: string, config: PrivateDnsMxRecordConfig);
    get fqdn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    get ttlInput(): number | undefined;
    private _zoneName?;
    get zoneName(): string;
    set zoneName(value: string);
    get zoneNameInput(): string | undefined;
    private _record?;
    get record(): PrivateDnsMxRecordRecord[] | cdktf.IResolvable;
    set record(value: PrivateDnsMxRecordRecord[] | cdktf.IResolvable);
    get recordInput(): cdktf.IResolvable | PrivateDnsMxRecordRecord[] | undefined;
    private _timeouts;
    get timeouts(): PrivateDnsMxRecordTimeoutsOutputReference;
    putTimeouts(value: PrivateDnsMxRecordTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): PrivateDnsMxRecordTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
