import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivateDnsSrvRecordConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#name PrivateDnsSrvRecord#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#resource_group_name PrivateDnsSrvRecord#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#tags PrivateDnsSrvRecord#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#ttl PrivateDnsSrvRecord#ttl}
    */
    readonly ttl: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#zone_name PrivateDnsSrvRecord#zone_name}
    */
    readonly zoneName: string;
    /**
    * record block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#record PrivateDnsSrvRecord#record}
    */
    readonly record: PrivateDnsSrvRecordRecord[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#timeouts PrivateDnsSrvRecord#timeouts}
    */
    readonly timeouts?: PrivateDnsSrvRecordTimeouts;
}
export interface PrivateDnsSrvRecordRecord {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#port PrivateDnsSrvRecord#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#priority PrivateDnsSrvRecord#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#target PrivateDnsSrvRecord#target}
    */
    readonly target: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#weight PrivateDnsSrvRecord#weight}
    */
    readonly weight: number;
}
export declare function privateDnsSrvRecordRecordToTerraform(struct?: PrivateDnsSrvRecordRecord | cdktf.IResolvable): any;
export interface PrivateDnsSrvRecordTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#create PrivateDnsSrvRecord#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#delete PrivateDnsSrvRecord#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#read PrivateDnsSrvRecord#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record#update PrivateDnsSrvRecord#update}
    */
    readonly update?: string;
}
export declare function privateDnsSrvRecordTimeoutsToTerraform(struct?: PrivateDnsSrvRecordTimeoutsOutputReference | PrivateDnsSrvRecordTimeouts | cdktf.IResolvable): any;
export declare class PrivateDnsSrvRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): PrivateDnsSrvRecordTimeouts | undefined;
    set internalValue(value: PrivateDnsSrvRecordTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record azurerm_private_dns_srv_record}
*/
export declare class PrivateDnsSrvRecord extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_srv_record azurerm_private_dns_srv_record} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivateDnsSrvRecordConfig
    */
    constructor(scope: Construct, id: string, config: PrivateDnsSrvRecordConfig);
    get fqdn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    get ttlInput(): number | undefined;
    private _zoneName?;
    get zoneName(): string;
    set zoneName(value: string);
    get zoneNameInput(): string | undefined;
    private _record?;
    get record(): PrivateDnsSrvRecordRecord[] | cdktf.IResolvable;
    set record(value: PrivateDnsSrvRecordRecord[] | cdktf.IResolvable);
    get recordInput(): cdktf.IResolvable | PrivateDnsSrvRecordRecord[] | undefined;
    private _timeouts;
    get timeouts(): PrivateDnsSrvRecordTimeoutsOutputReference;
    putTimeouts(value: PrivateDnsSrvRecordTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): PrivateDnsSrvRecordTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
