import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PublicIpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#allocation_method PublicIp#allocation_method}
    */
    readonly allocationMethod: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#availability_zone PublicIp#availability_zone}
    */
    readonly availabilityZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#domain_name_label PublicIp#domain_name_label}
    */
    readonly domainNameLabel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#idle_timeout_in_minutes PublicIp#idle_timeout_in_minutes}
    */
    readonly idleTimeoutInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#ip_tags PublicIp#ip_tags}
    */
    readonly ipTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#ip_version PublicIp#ip_version}
    */
    readonly ipVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#location PublicIp#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#name PublicIp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#public_ip_prefix_id PublicIp#public_ip_prefix_id}
    */
    readonly publicIpPrefixId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#resource_group_name PublicIp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#reverse_fqdn PublicIp#reverse_fqdn}
    */
    readonly reverseFqdn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#sku PublicIp#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#sku_tier PublicIp#sku_tier}
    */
    readonly skuTier?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#tags PublicIp#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#zones PublicIp#zones}
    */
    readonly zones?: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#timeouts PublicIp#timeouts}
    */
    readonly timeouts?: PublicIpTimeouts;
}
export interface PublicIpTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#create PublicIp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#delete PublicIp#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#read PublicIp#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip#update PublicIp#update}
    */
    readonly update?: string;
}
export declare function publicIpTimeoutsToTerraform(struct?: PublicIpTimeoutsOutputReference | PublicIpTimeouts | cdktf.IResolvable): any;
export declare class PublicIpTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): PublicIpTimeouts | undefined;
    set internalValue(value: PublicIpTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip azurerm_public_ip}
*/
export declare class PublicIp extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/public_ip azurerm_public_ip} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PublicIpConfig
    */
    constructor(scope: Construct, id: string, config: PublicIpConfig);
    private _allocationMethod?;
    get allocationMethod(): string;
    set allocationMethod(value: string);
    get allocationMethodInput(): string | undefined;
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    resetAvailabilityZone(): void;
    get availabilityZoneInput(): string | undefined;
    private _domainNameLabel?;
    get domainNameLabel(): string;
    set domainNameLabel(value: string);
    resetDomainNameLabel(): void;
    get domainNameLabelInput(): string | undefined;
    get fqdn(): string;
    get id(): string;
    private _idleTimeoutInMinutes?;
    get idleTimeoutInMinutes(): number;
    set idleTimeoutInMinutes(value: number);
    resetIdleTimeoutInMinutes(): void;
    get idleTimeoutInMinutesInput(): number | undefined;
    get ipAddress(): string;
    private _ipTags?;
    get ipTags(): {
        [key: string]: string;
    };
    set ipTags(value: {
        [key: string]: string;
    });
    resetIpTags(): void;
    get ipTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ipVersion?;
    get ipVersion(): string;
    set ipVersion(value: string);
    resetIpVersion(): void;
    get ipVersionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicIpPrefixId?;
    get publicIpPrefixId(): string;
    set publicIpPrefixId(value: string);
    resetPublicIpPrefixId(): void;
    get publicIpPrefixIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _reverseFqdn?;
    get reverseFqdn(): string;
    set reverseFqdn(value: string);
    resetReverseFqdn(): void;
    get reverseFqdnInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _skuTier?;
    get skuTier(): string;
    set skuTier(value: string);
    resetSkuTier(): void;
    get skuTierInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _timeouts;
    get timeouts(): PublicIpTimeoutsOutputReference;
    putTimeouts(value: PublicIpTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): PublicIpTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
