import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PurviewAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/purview_account#location PurviewAccount#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/purview_account#managed_resource_group_name PurviewAccount#managed_resource_group_name}
    */
    readonly managedResourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/purview_account#name PurviewAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/purview_account#public_network_enabled PurviewAccount#public_network_enabled}
    */
    readonly publicNetworkEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/purview_account#resource_group_name PurviewAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/purview_account#sku_name PurviewAccount#sku_name}
    */
    readonly skuName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/purview_account#tags PurviewAccount#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/purview_account#timeouts PurviewAccount#timeouts}
    */
    readonly timeouts?: PurviewAccountTimeouts;
}
export declare class PurviewAccountIdentity extends cdktf.ComplexComputedList {
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class PurviewAccountManagedResources extends cdktf.ComplexComputedList {
    get eventHubNamespaceId(): string;
    get resourceGroupId(): string;
    get storageAccountId(): string;
}
export interface PurviewAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/purview_account#create PurviewAccount#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/purview_account#delete PurviewAccount#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/purview_account#read PurviewAccount#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/purview_account#update PurviewAccount#update}
    */
    readonly update?: string;
}
export declare function purviewAccountTimeoutsToTerraform(struct?: PurviewAccountTimeoutsOutputReference | PurviewAccountTimeouts | cdktf.IResolvable): any;
export declare class PurviewAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): PurviewAccountTimeouts | undefined;
    set internalValue(value: PurviewAccountTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/purview_account azurerm_purview_account}
*/
export declare class PurviewAccount extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/purview_account azurerm_purview_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PurviewAccountConfig
    */
    constructor(scope: Construct, id: string, config: PurviewAccountConfig);
    get atlasKafkaEndpointPrimaryConnectionString(): string;
    get atlasKafkaEndpointSecondaryConnectionString(): string;
    get catalogEndpoint(): string;
    get guardianEndpoint(): string;
    get id(): string;
    identity(index: string): PurviewAccountIdentity;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _managedResourceGroupName?;
    get managedResourceGroupName(): string;
    set managedResourceGroupName(value: string);
    resetManagedResourceGroupName(): void;
    get managedResourceGroupNameInput(): string | undefined;
    managedResources(index: string): PurviewAccountManagedResources;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicNetworkEnabled?;
    get publicNetworkEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkEnabled(): void;
    get publicNetworkEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get scanEndpoint(): string;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    resetSkuName(): void;
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): PurviewAccountTimeoutsOutputReference;
    putTimeouts(value: PurviewAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): PurviewAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
