import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceProviderRegistrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#name ResourceProviderRegistration#name}
    */
    readonly name: string;
    /**
    * feature block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#feature ResourceProviderRegistration#feature}
    */
    readonly feature?: ResourceProviderRegistrationFeature[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#timeouts ResourceProviderRegistration#timeouts}
    */
    readonly timeouts?: ResourceProviderRegistrationTimeouts;
}
export interface ResourceProviderRegistrationFeature {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#name ResourceProviderRegistration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#registered ResourceProviderRegistration#registered}
    */
    readonly registered: boolean | cdktf.IResolvable;
}
export declare function resourceProviderRegistrationFeatureToTerraform(struct?: ResourceProviderRegistrationFeature | cdktf.IResolvable): any;
export interface ResourceProviderRegistrationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#create ResourceProviderRegistration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#delete ResourceProviderRegistration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#read ResourceProviderRegistration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration#update ResourceProviderRegistration#update}
    */
    readonly update?: string;
}
export declare function resourceProviderRegistrationTimeoutsToTerraform(struct?: ResourceProviderRegistrationTimeoutsOutputReference | ResourceProviderRegistrationTimeouts | cdktf.IResolvable): any;
export declare class ResourceProviderRegistrationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ResourceProviderRegistrationTimeouts | undefined;
    set internalValue(value: ResourceProviderRegistrationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration azurerm_resource_provider_registration}
*/
export declare class ResourceProviderRegistration extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/resource_provider_registration azurerm_resource_provider_registration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceProviderRegistrationConfig
    */
    constructor(scope: Construct, id: string, config: ResourceProviderRegistrationConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _feature?;
    get feature(): ResourceProviderRegistrationFeature[] | cdktf.IResolvable;
    set feature(value: ResourceProviderRegistrationFeature[] | cdktf.IResolvable);
    resetFeature(): void;
    get featureInput(): cdktf.IResolvable | ResourceProviderRegistrationFeature[] | undefined;
    private _timeouts;
    get timeouts(): ResourceProviderRegistrationTimeoutsOutputReference;
    putTimeouts(value: ResourceProviderRegistrationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ResourceProviderRegistrationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
