import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SentinelAlertRuleScheduledConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#alert_rule_template_guid SentinelAlertRuleScheduled#alert_rule_template_guid}
    */
    readonly alertRuleTemplateGuid?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#description SentinelAlertRuleScheduled#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#display_name SentinelAlertRuleScheduled#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#enabled SentinelAlertRuleScheduled#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#log_analytics_workspace_id SentinelAlertRuleScheduled#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#name SentinelAlertRuleScheduled#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#query SentinelAlertRuleScheduled#query}
    */
    readonly query: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#query_frequency SentinelAlertRuleScheduled#query_frequency}
    */
    readonly queryFrequency?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#query_period SentinelAlertRuleScheduled#query_period}
    */
    readonly queryPeriod?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#severity SentinelAlertRuleScheduled#severity}
    */
    readonly severity: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#suppression_duration SentinelAlertRuleScheduled#suppression_duration}
    */
    readonly suppressionDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#suppression_enabled SentinelAlertRuleScheduled#suppression_enabled}
    */
    readonly suppressionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#tactics SentinelAlertRuleScheduled#tactics}
    */
    readonly tactics?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#trigger_operator SentinelAlertRuleScheduled#trigger_operator}
    */
    readonly triggerOperator?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#trigger_threshold SentinelAlertRuleScheduled#trigger_threshold}
    */
    readonly triggerThreshold?: number;
    /**
    * event_grouping block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#event_grouping SentinelAlertRuleScheduled#event_grouping}
    */
    readonly eventGrouping?: SentinelAlertRuleScheduledEventGrouping;
    /**
    * incident_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#incident_configuration SentinelAlertRuleScheduled#incident_configuration}
    */
    readonly incidentConfiguration?: SentinelAlertRuleScheduledIncidentConfiguration;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#timeouts SentinelAlertRuleScheduled#timeouts}
    */
    readonly timeouts?: SentinelAlertRuleScheduledTimeouts;
}
export interface SentinelAlertRuleScheduledEventGrouping {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#aggregation_method SentinelAlertRuleScheduled#aggregation_method}
    */
    readonly aggregationMethod: string;
}
export declare function sentinelAlertRuleScheduledEventGroupingToTerraform(struct?: SentinelAlertRuleScheduledEventGroupingOutputReference | SentinelAlertRuleScheduledEventGrouping): any;
export declare class SentinelAlertRuleScheduledEventGroupingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SentinelAlertRuleScheduledEventGrouping | undefined;
    set internalValue(value: SentinelAlertRuleScheduledEventGrouping | undefined);
    private _aggregationMethod?;
    get aggregationMethod(): string;
    set aggregationMethod(value: string);
    get aggregationMethodInput(): string | undefined;
}
export interface SentinelAlertRuleScheduledIncidentConfigurationGrouping {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#enabled SentinelAlertRuleScheduled#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#entity_matching_method SentinelAlertRuleScheduled#entity_matching_method}
    */
    readonly entityMatchingMethod?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#group_by SentinelAlertRuleScheduled#group_by}
    */
    readonly groupBy?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#lookback_duration SentinelAlertRuleScheduled#lookback_duration}
    */
    readonly lookbackDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#reopen_closed_incidents SentinelAlertRuleScheduled#reopen_closed_incidents}
    */
    readonly reopenClosedIncidents?: boolean | cdktf.IResolvable;
}
export declare function sentinelAlertRuleScheduledIncidentConfigurationGroupingToTerraform(struct?: SentinelAlertRuleScheduledIncidentConfigurationGroupingOutputReference | SentinelAlertRuleScheduledIncidentConfigurationGrouping): any;
export declare class SentinelAlertRuleScheduledIncidentConfigurationGroupingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SentinelAlertRuleScheduledIncidentConfigurationGrouping | undefined;
    set internalValue(value: SentinelAlertRuleScheduledIncidentConfigurationGrouping | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _entityMatchingMethod?;
    get entityMatchingMethod(): string;
    set entityMatchingMethod(value: string);
    resetEntityMatchingMethod(): void;
    get entityMatchingMethodInput(): string | undefined;
    private _groupBy?;
    get groupBy(): string[];
    set groupBy(value: string[]);
    resetGroupBy(): void;
    get groupByInput(): string[] | undefined;
    private _lookbackDuration?;
    get lookbackDuration(): string;
    set lookbackDuration(value: string);
    resetLookbackDuration(): void;
    get lookbackDurationInput(): string | undefined;
    private _reopenClosedIncidents?;
    get reopenClosedIncidents(): boolean | cdktf.IResolvable;
    set reopenClosedIncidents(value: boolean | cdktf.IResolvable);
    resetReopenClosedIncidents(): void;
    get reopenClosedIncidentsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SentinelAlertRuleScheduledIncidentConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#create_incident SentinelAlertRuleScheduled#create_incident}
    */
    readonly createIncident: boolean | cdktf.IResolvable;
    /**
    * grouping block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#grouping SentinelAlertRuleScheduled#grouping}
    */
    readonly grouping: SentinelAlertRuleScheduledIncidentConfigurationGrouping;
}
export declare function sentinelAlertRuleScheduledIncidentConfigurationToTerraform(struct?: SentinelAlertRuleScheduledIncidentConfigurationOutputReference | SentinelAlertRuleScheduledIncidentConfiguration): any;
export declare class SentinelAlertRuleScheduledIncidentConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SentinelAlertRuleScheduledIncidentConfiguration | undefined;
    set internalValue(value: SentinelAlertRuleScheduledIncidentConfiguration | undefined);
    private _createIncident?;
    get createIncident(): boolean | cdktf.IResolvable;
    set createIncident(value: boolean | cdktf.IResolvable);
    get createIncidentInput(): boolean | cdktf.IResolvable | undefined;
    private _grouping;
    get grouping(): SentinelAlertRuleScheduledIncidentConfigurationGroupingOutputReference;
    putGrouping(value: SentinelAlertRuleScheduledIncidentConfigurationGrouping): void;
    get groupingInput(): SentinelAlertRuleScheduledIncidentConfigurationGrouping | undefined;
}
export interface SentinelAlertRuleScheduledTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#create SentinelAlertRuleScheduled#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#delete SentinelAlertRuleScheduled#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#read SentinelAlertRuleScheduled#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled#update SentinelAlertRuleScheduled#update}
    */
    readonly update?: string;
}
export declare function sentinelAlertRuleScheduledTimeoutsToTerraform(struct?: SentinelAlertRuleScheduledTimeoutsOutputReference | SentinelAlertRuleScheduledTimeouts | cdktf.IResolvable): any;
export declare class SentinelAlertRuleScheduledTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SentinelAlertRuleScheduledTimeouts | undefined;
    set internalValue(value: SentinelAlertRuleScheduledTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled azurerm_sentinel_alert_rule_scheduled}
*/
export declare class SentinelAlertRuleScheduled extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_scheduled azurerm_sentinel_alert_rule_scheduled} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SentinelAlertRuleScheduledConfig
    */
    constructor(scope: Construct, id: string, config: SentinelAlertRuleScheduledConfig);
    private _alertRuleTemplateGuid?;
    get alertRuleTemplateGuid(): string;
    set alertRuleTemplateGuid(value: string);
    resetAlertRuleTemplateGuid(): void;
    get alertRuleTemplateGuidInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _queryFrequency?;
    get queryFrequency(): string;
    set queryFrequency(value: string);
    resetQueryFrequency(): void;
    get queryFrequencyInput(): string | undefined;
    private _queryPeriod?;
    get queryPeriod(): string;
    set queryPeriod(value: string);
    resetQueryPeriod(): void;
    get queryPeriodInput(): string | undefined;
    private _severity?;
    get severity(): string;
    set severity(value: string);
    get severityInput(): string | undefined;
    private _suppressionDuration?;
    get suppressionDuration(): string;
    set suppressionDuration(value: string);
    resetSuppressionDuration(): void;
    get suppressionDurationInput(): string | undefined;
    private _suppressionEnabled?;
    get suppressionEnabled(): boolean | cdktf.IResolvable;
    set suppressionEnabled(value: boolean | cdktf.IResolvable);
    resetSuppressionEnabled(): void;
    get suppressionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tactics?;
    get tactics(): string[];
    set tactics(value: string[]);
    resetTactics(): void;
    get tacticsInput(): string[] | undefined;
    private _triggerOperator?;
    get triggerOperator(): string;
    set triggerOperator(value: string);
    resetTriggerOperator(): void;
    get triggerOperatorInput(): string | undefined;
    private _triggerThreshold?;
    get triggerThreshold(): number;
    set triggerThreshold(value: number);
    resetTriggerThreshold(): void;
    get triggerThresholdInput(): number | undefined;
    private _eventGrouping;
    get eventGrouping(): SentinelAlertRuleScheduledEventGroupingOutputReference;
    putEventGrouping(value: SentinelAlertRuleScheduledEventGrouping): void;
    resetEventGrouping(): void;
    get eventGroupingInput(): SentinelAlertRuleScheduledEventGrouping | undefined;
    private _incidentConfiguration;
    get incidentConfiguration(): SentinelAlertRuleScheduledIncidentConfigurationOutputReference;
    putIncidentConfiguration(value: SentinelAlertRuleScheduledIncidentConfiguration): void;
    resetIncidentConfiguration(): void;
    get incidentConfigurationInput(): SentinelAlertRuleScheduledIncidentConfiguration | undefined;
    private _timeouts;
    get timeouts(): SentinelAlertRuleScheduledTimeoutsOutputReference;
    putTimeouts(value: SentinelAlertRuleScheduledTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SentinelAlertRuleScheduledTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
