import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SentinelDataConnectorAzureActiveDirectoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_azure_active_directory#log_analytics_workspace_id SentinelDataConnectorAzureActiveDirectory#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_azure_active_directory#name SentinelDataConnectorAzureActiveDirectory#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_azure_active_directory#tenant_id SentinelDataConnectorAzureActiveDirectory#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_azure_active_directory#timeouts SentinelDataConnectorAzureActiveDirectory#timeouts}
    */
    readonly timeouts?: SentinelDataConnectorAzureActiveDirectoryTimeouts;
}
export interface SentinelDataConnectorAzureActiveDirectoryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_azure_active_directory#create SentinelDataConnectorAzureActiveDirectory#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_azure_active_directory#delete SentinelDataConnectorAzureActiveDirectory#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_azure_active_directory#read SentinelDataConnectorAzureActiveDirectory#read}
    */
    readonly read?: string;
}
export declare function sentinelDataConnectorAzureActiveDirectoryTimeoutsToTerraform(struct?: SentinelDataConnectorAzureActiveDirectoryTimeoutsOutputReference | SentinelDataConnectorAzureActiveDirectoryTimeouts | cdktf.IResolvable): any;
export declare class SentinelDataConnectorAzureActiveDirectoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SentinelDataConnectorAzureActiveDirectoryTimeouts | undefined;
    set internalValue(value: SentinelDataConnectorAzureActiveDirectoryTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_azure_active_directory azurerm_sentinel_data_connector_azure_active_directory}
*/
export declare class SentinelDataConnectorAzureActiveDirectory extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_azure_active_directory azurerm_sentinel_data_connector_azure_active_directory} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SentinelDataConnectorAzureActiveDirectoryConfig
    */
    constructor(scope: Construct, id: string, config: SentinelDataConnectorAzureActiveDirectoryConfig);
    get id(): string;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SentinelDataConnectorAzureActiveDirectoryTimeoutsOutputReference;
    putTimeouts(value: SentinelDataConnectorAzureActiveDirectoryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SentinelDataConnectorAzureActiveDirectoryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
