import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicebusTopicAuthorizationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic_authorization_rule#listen ServicebusTopicAuthorizationRule#listen}
    */
    readonly listen?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic_authorization_rule#manage ServicebusTopicAuthorizationRule#manage}
    */
    readonly manage?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic_authorization_rule#name ServicebusTopicAuthorizationRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic_authorization_rule#namespace_name ServicebusTopicAuthorizationRule#namespace_name}
    */
    readonly namespaceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic_authorization_rule#resource_group_name ServicebusTopicAuthorizationRule#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic_authorization_rule#send ServicebusTopicAuthorizationRule#send}
    */
    readonly send?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic_authorization_rule#topic_id ServicebusTopicAuthorizationRule#topic_id}
    */
    readonly topicId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic_authorization_rule#topic_name ServicebusTopicAuthorizationRule#topic_name}
    */
    readonly topicName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic_authorization_rule#timeouts ServicebusTopicAuthorizationRule#timeouts}
    */
    readonly timeouts?: ServicebusTopicAuthorizationRuleTimeouts;
}
export interface ServicebusTopicAuthorizationRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic_authorization_rule#create ServicebusTopicAuthorizationRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic_authorization_rule#delete ServicebusTopicAuthorizationRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic_authorization_rule#read ServicebusTopicAuthorizationRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic_authorization_rule#update ServicebusTopicAuthorizationRule#update}
    */
    readonly update?: string;
}
export declare function servicebusTopicAuthorizationRuleTimeoutsToTerraform(struct?: ServicebusTopicAuthorizationRuleTimeoutsOutputReference | ServicebusTopicAuthorizationRuleTimeouts | cdktf.IResolvable): any;
export declare class ServicebusTopicAuthorizationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ServicebusTopicAuthorizationRuleTimeouts | undefined;
    set internalValue(value: ServicebusTopicAuthorizationRuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic_authorization_rule azurerm_servicebus_topic_authorization_rule}
*/
export declare class ServicebusTopicAuthorizationRule extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_topic_authorization_rule azurerm_servicebus_topic_authorization_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicebusTopicAuthorizationRuleConfig
    */
    constructor(scope: Construct, id: string, config: ServicebusTopicAuthorizationRuleConfig);
    get id(): string;
    private _listen?;
    get listen(): boolean | cdktf.IResolvable;
    set listen(value: boolean | cdktf.IResolvable);
    resetListen(): void;
    get listenInput(): boolean | cdktf.IResolvable | undefined;
    private _manage?;
    get manage(): boolean | cdktf.IResolvable;
    set manage(value: boolean | cdktf.IResolvable);
    resetManage(): void;
    get manageInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    resetNamespaceName(): void;
    get namespaceNameInput(): string | undefined;
    get primaryConnectionString(): string;
    get primaryConnectionStringAlias(): string;
    get primaryKey(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    get secondaryConnectionString(): string;
    get secondaryConnectionStringAlias(): string;
    get secondaryKey(): string;
    private _send?;
    get send(): boolean | cdktf.IResolvable;
    set send(value: boolean | cdktf.IResolvable);
    resetSend(): void;
    get sendInput(): boolean | cdktf.IResolvable | undefined;
    private _topicId?;
    get topicId(): string;
    set topicId(value: string);
    resetTopicId(): void;
    get topicIdInput(): string | undefined;
    private _topicName?;
    get topicName(): string;
    set topicName(value: string);
    resetTopicName(): void;
    get topicNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ServicebusTopicAuthorizationRuleTimeoutsOutputReference;
    putTimeouts(value: ServicebusTopicAuthorizationRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ServicebusTopicAuthorizationRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
