import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SiteRecoveryReplicatedVmConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#managed_disk SiteRecoveryReplicatedVm#managed_disk}
    */
    readonly managedDisk?: SiteRecoveryReplicatedVmManagedDisk[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#name SiteRecoveryReplicatedVm#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#network_interface SiteRecoveryReplicatedVm#network_interface}
    */
    readonly networkInterface?: SiteRecoveryReplicatedVmNetworkInterface[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#recovery_replication_policy_id SiteRecoveryReplicatedVm#recovery_replication_policy_id}
    */
    readonly recoveryReplicationPolicyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#recovery_vault_name SiteRecoveryReplicatedVm#recovery_vault_name}
    */
    readonly recoveryVaultName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#resource_group_name SiteRecoveryReplicatedVm#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#source_recovery_fabric_name SiteRecoveryReplicatedVm#source_recovery_fabric_name}
    */
    readonly sourceRecoveryFabricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#source_recovery_protection_container_name SiteRecoveryReplicatedVm#source_recovery_protection_container_name}
    */
    readonly sourceRecoveryProtectionContainerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#source_vm_id SiteRecoveryReplicatedVm#source_vm_id}
    */
    readonly sourceVmId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#target_availability_set_id SiteRecoveryReplicatedVm#target_availability_set_id}
    */
    readonly targetAvailabilitySetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#target_network_id SiteRecoveryReplicatedVm#target_network_id}
    */
    readonly targetNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#target_recovery_fabric_id SiteRecoveryReplicatedVm#target_recovery_fabric_id}
    */
    readonly targetRecoveryFabricId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#target_recovery_protection_container_id SiteRecoveryReplicatedVm#target_recovery_protection_container_id}
    */
    readonly targetRecoveryProtectionContainerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#target_resource_group_id SiteRecoveryReplicatedVm#target_resource_group_id}
    */
    readonly targetResourceGroupId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#timeouts SiteRecoveryReplicatedVm#timeouts}
    */
    readonly timeouts?: SiteRecoveryReplicatedVmTimeouts;
}
export interface SiteRecoveryReplicatedVmManagedDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#disk_id SiteRecoveryReplicatedVm#disk_id}
    */
    readonly diskId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#staging_storage_account_id SiteRecoveryReplicatedVm#staging_storage_account_id}
    */
    readonly stagingStorageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#target_disk_encryption_set_id SiteRecoveryReplicatedVm#target_disk_encryption_set_id}
    */
    readonly targetDiskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#target_disk_type SiteRecoveryReplicatedVm#target_disk_type}
    */
    readonly targetDiskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#target_replica_disk_type SiteRecoveryReplicatedVm#target_replica_disk_type}
    */
    readonly targetReplicaDiskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#target_resource_group_id SiteRecoveryReplicatedVm#target_resource_group_id}
    */
    readonly targetResourceGroupId?: string;
}
export declare function siteRecoveryReplicatedVmManagedDiskToTerraform(struct?: SiteRecoveryReplicatedVmManagedDisk | cdktf.IResolvable): any;
export interface SiteRecoveryReplicatedVmNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#recovery_public_ip_address_id SiteRecoveryReplicatedVm#recovery_public_ip_address_id}
    */
    readonly recoveryPublicIpAddressId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#source_network_interface_id SiteRecoveryReplicatedVm#source_network_interface_id}
    */
    readonly sourceNetworkInterfaceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#target_static_ip SiteRecoveryReplicatedVm#target_static_ip}
    */
    readonly targetStaticIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#target_subnet_name SiteRecoveryReplicatedVm#target_subnet_name}
    */
    readonly targetSubnetName?: string;
}
export declare function siteRecoveryReplicatedVmNetworkInterfaceToTerraform(struct?: SiteRecoveryReplicatedVmNetworkInterface | cdktf.IResolvable): any;
export interface SiteRecoveryReplicatedVmTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#create SiteRecoveryReplicatedVm#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#delete SiteRecoveryReplicatedVm#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#read SiteRecoveryReplicatedVm#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm#update SiteRecoveryReplicatedVm#update}
    */
    readonly update?: string;
}
export declare function siteRecoveryReplicatedVmTimeoutsToTerraform(struct?: SiteRecoveryReplicatedVmTimeoutsOutputReference | SiteRecoveryReplicatedVmTimeouts | cdktf.IResolvable): any;
export declare class SiteRecoveryReplicatedVmTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SiteRecoveryReplicatedVmTimeouts | undefined;
    set internalValue(value: SiteRecoveryReplicatedVmTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm azurerm_site_recovery_replicated_vm}
*/
export declare class SiteRecoveryReplicatedVm extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm azurerm_site_recovery_replicated_vm} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SiteRecoveryReplicatedVmConfig
    */
    constructor(scope: Construct, id: string, config: SiteRecoveryReplicatedVmConfig);
    get id(): string;
    private _managedDisk?;
    get managedDisk(): SiteRecoveryReplicatedVmManagedDisk[] | cdktf.IResolvable;
    set managedDisk(value: SiteRecoveryReplicatedVmManagedDisk[] | cdktf.IResolvable);
    resetManagedDisk(): void;
    get managedDiskInput(): cdktf.IResolvable | SiteRecoveryReplicatedVmManagedDisk[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkInterface?;
    get networkInterface(): SiteRecoveryReplicatedVmNetworkInterface[] | cdktf.IResolvable;
    set networkInterface(value: SiteRecoveryReplicatedVmNetworkInterface[] | cdktf.IResolvable);
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | SiteRecoveryReplicatedVmNetworkInterface[] | undefined;
    private _recoveryReplicationPolicyId?;
    get recoveryReplicationPolicyId(): string;
    set recoveryReplicationPolicyId(value: string);
    get recoveryReplicationPolicyIdInput(): string | undefined;
    private _recoveryVaultName?;
    get recoveryVaultName(): string;
    set recoveryVaultName(value: string);
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sourceRecoveryFabricName?;
    get sourceRecoveryFabricName(): string;
    set sourceRecoveryFabricName(value: string);
    get sourceRecoveryFabricNameInput(): string | undefined;
    private _sourceRecoveryProtectionContainerName?;
    get sourceRecoveryProtectionContainerName(): string;
    set sourceRecoveryProtectionContainerName(value: string);
    get sourceRecoveryProtectionContainerNameInput(): string | undefined;
    private _sourceVmId?;
    get sourceVmId(): string;
    set sourceVmId(value: string);
    get sourceVmIdInput(): string | undefined;
    private _targetAvailabilitySetId?;
    get targetAvailabilitySetId(): string;
    set targetAvailabilitySetId(value: string);
    resetTargetAvailabilitySetId(): void;
    get targetAvailabilitySetIdInput(): string | undefined;
    private _targetNetworkId?;
    get targetNetworkId(): string;
    set targetNetworkId(value: string);
    resetTargetNetworkId(): void;
    get targetNetworkIdInput(): string | undefined;
    private _targetRecoveryFabricId?;
    get targetRecoveryFabricId(): string;
    set targetRecoveryFabricId(value: string);
    get targetRecoveryFabricIdInput(): string | undefined;
    private _targetRecoveryProtectionContainerId?;
    get targetRecoveryProtectionContainerId(): string;
    set targetRecoveryProtectionContainerId(value: string);
    get targetRecoveryProtectionContainerIdInput(): string | undefined;
    private _targetResourceGroupId?;
    get targetResourceGroupId(): string;
    set targetResourceGroupId(value: string);
    get targetResourceGroupIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SiteRecoveryReplicatedVmTimeoutsOutputReference;
    putTimeouts(value: SiteRecoveryReplicatedVmTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SiteRecoveryReplicatedVmTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
