import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#certificate_content SpringCloudCertificate#certificate_content}
    */
    readonly certificateContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#key_vault_certificate_id SpringCloudCertificate#key_vault_certificate_id}
    */
    readonly keyVaultCertificateId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#name SpringCloudCertificate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#resource_group_name SpringCloudCertificate#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#service_name SpringCloudCertificate#service_name}
    */
    readonly serviceName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#timeouts SpringCloudCertificate#timeouts}
    */
    readonly timeouts?: SpringCloudCertificateTimeouts;
}
export interface SpringCloudCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#create SpringCloudCertificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#delete SpringCloudCertificate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate#read SpringCloudCertificate#read}
    */
    readonly read?: string;
}
export declare function springCloudCertificateTimeoutsToTerraform(struct?: SpringCloudCertificateTimeoutsOutputReference | SpringCloudCertificateTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SpringCloudCertificateTimeouts | undefined;
    set internalValue(value: SpringCloudCertificateTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate azurerm_spring_cloud_certificate}
*/
export declare class SpringCloudCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_certificate azurerm_spring_cloud_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudCertificateConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudCertificateConfig);
    private _certificateContent?;
    get certificateContent(): string;
    set certificateContent(value: string);
    resetCertificateContent(): void;
    get certificateContentInput(): string | undefined;
    get id(): string;
    private _keyVaultCertificateId?;
    get keyVaultCertificateId(): string;
    set keyVaultCertificateId(value: string);
    resetKeyVaultCertificateId(): void;
    get keyVaultCertificateIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    get thumbprint(): string;
    private _timeouts;
    get timeouts(): SpringCloudCertificateTimeoutsOutputReference;
    putTimeouts(value: SpringCloudCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SpringCloudCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
