import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#location SpringCloudService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#name SpringCloudService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#resource_group_name SpringCloudService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#sku_name SpringCloudService#sku_name}
    */
    readonly skuName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#tags SpringCloudService#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * config_server_git_setting block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#config_server_git_setting SpringCloudService#config_server_git_setting}
    */
    readonly configServerGitSetting?: SpringCloudServiceConfigServerGitSetting;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#network SpringCloudService#network}
    */
    readonly network?: SpringCloudServiceNetwork;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#timeouts SpringCloudService#timeouts}
    */
    readonly timeouts?: SpringCloudServiceTimeouts;
    /**
    * trace block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#trace SpringCloudService#trace}
    */
    readonly trace?: SpringCloudServiceTrace;
}
export declare class SpringCloudServiceRequiredNetworkTrafficRules extends cdktf.ComplexComputedList {
    get direction(): string;
    get fqdns(): string[];
    get ipAddresses(): string[];
    get port(): number;
    get protocol(): string;
}
export interface SpringCloudServiceConfigServerGitSettingHttpBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#password SpringCloudService#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#username SpringCloudService#username}
    */
    readonly username: string;
}
export declare function springCloudServiceConfigServerGitSettingHttpBasicAuthToTerraform(struct?: SpringCloudServiceConfigServerGitSettingHttpBasicAuthOutputReference | SpringCloudServiceConfigServerGitSettingHttpBasicAuth): any;
export declare class SpringCloudServiceConfigServerGitSettingHttpBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SpringCloudServiceConfigServerGitSettingHttpBasicAuth | undefined;
    set internalValue(value: SpringCloudServiceConfigServerGitSettingHttpBasicAuth | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#password SpringCloudService#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#username SpringCloudService#username}
    */
    readonly username: string;
}
export declare function springCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthToTerraform(struct?: SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthOutputReference | SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth): any;
export declare class SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth | undefined;
    set internalValue(value: SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface SpringCloudServiceConfigServerGitSettingRepositorySshAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#host_key SpringCloudService#host_key}
    */
    readonly hostKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#host_key_algorithm SpringCloudService#host_key_algorithm}
    */
    readonly hostKeyAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#private_key SpringCloudService#private_key}
    */
    readonly privateKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#strict_host_key_checking_enabled SpringCloudService#strict_host_key_checking_enabled}
    */
    readonly strictHostKeyCheckingEnabled?: boolean | cdktf.IResolvable;
}
export declare function springCloudServiceConfigServerGitSettingRepositorySshAuthToTerraform(struct?: SpringCloudServiceConfigServerGitSettingRepositorySshAuthOutputReference | SpringCloudServiceConfigServerGitSettingRepositorySshAuth): any;
export declare class SpringCloudServiceConfigServerGitSettingRepositorySshAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SpringCloudServiceConfigServerGitSettingRepositorySshAuth | undefined;
    set internalValue(value: SpringCloudServiceConfigServerGitSettingRepositorySshAuth | undefined);
    private _hostKey?;
    get hostKey(): string;
    set hostKey(value: string);
    resetHostKey(): void;
    get hostKeyInput(): string | undefined;
    private _hostKeyAlgorithm?;
    get hostKeyAlgorithm(): string;
    set hostKeyAlgorithm(value: string);
    resetHostKeyAlgorithm(): void;
    get hostKeyAlgorithmInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    get privateKeyInput(): string | undefined;
    private _strictHostKeyCheckingEnabled?;
    get strictHostKeyCheckingEnabled(): boolean | cdktf.IResolvable;
    set strictHostKeyCheckingEnabled(value: boolean | cdktf.IResolvable);
    resetStrictHostKeyCheckingEnabled(): void;
    get strictHostKeyCheckingEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SpringCloudServiceConfigServerGitSettingRepository {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#label SpringCloudService#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#name SpringCloudService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#pattern SpringCloudService#pattern}
    */
    readonly pattern?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#search_paths SpringCloudService#search_paths}
    */
    readonly searchPaths?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#uri SpringCloudService#uri}
    */
    readonly uri: string;
    /**
    * http_basic_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#http_basic_auth SpringCloudService#http_basic_auth}
    */
    readonly httpBasicAuth?: SpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth;
    /**
    * ssh_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#ssh_auth SpringCloudService#ssh_auth}
    */
    readonly sshAuth?: SpringCloudServiceConfigServerGitSettingRepositorySshAuth;
}
export declare function springCloudServiceConfigServerGitSettingRepositoryToTerraform(struct?: SpringCloudServiceConfigServerGitSettingRepository | cdktf.IResolvable): any;
export interface SpringCloudServiceConfigServerGitSettingSshAuth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#host_key SpringCloudService#host_key}
    */
    readonly hostKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#host_key_algorithm SpringCloudService#host_key_algorithm}
    */
    readonly hostKeyAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#private_key SpringCloudService#private_key}
    */
    readonly privateKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#strict_host_key_checking_enabled SpringCloudService#strict_host_key_checking_enabled}
    */
    readonly strictHostKeyCheckingEnabled?: boolean | cdktf.IResolvable;
}
export declare function springCloudServiceConfigServerGitSettingSshAuthToTerraform(struct?: SpringCloudServiceConfigServerGitSettingSshAuthOutputReference | SpringCloudServiceConfigServerGitSettingSshAuth): any;
export declare class SpringCloudServiceConfigServerGitSettingSshAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SpringCloudServiceConfigServerGitSettingSshAuth | undefined;
    set internalValue(value: SpringCloudServiceConfigServerGitSettingSshAuth | undefined);
    private _hostKey?;
    get hostKey(): string;
    set hostKey(value: string);
    resetHostKey(): void;
    get hostKeyInput(): string | undefined;
    private _hostKeyAlgorithm?;
    get hostKeyAlgorithm(): string;
    set hostKeyAlgorithm(value: string);
    resetHostKeyAlgorithm(): void;
    get hostKeyAlgorithmInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    get privateKeyInput(): string | undefined;
    private _strictHostKeyCheckingEnabled?;
    get strictHostKeyCheckingEnabled(): boolean | cdktf.IResolvable;
    set strictHostKeyCheckingEnabled(value: boolean | cdktf.IResolvable);
    resetStrictHostKeyCheckingEnabled(): void;
    get strictHostKeyCheckingEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SpringCloudServiceConfigServerGitSetting {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#label SpringCloudService#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#search_paths SpringCloudService#search_paths}
    */
    readonly searchPaths?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#uri SpringCloudService#uri}
    */
    readonly uri: string;
    /**
    * http_basic_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#http_basic_auth SpringCloudService#http_basic_auth}
    */
    readonly httpBasicAuth?: SpringCloudServiceConfigServerGitSettingHttpBasicAuth;
    /**
    * repository block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#repository SpringCloudService#repository}
    */
    readonly repository?: SpringCloudServiceConfigServerGitSettingRepository[] | cdktf.IResolvable;
    /**
    * ssh_auth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#ssh_auth SpringCloudService#ssh_auth}
    */
    readonly sshAuth?: SpringCloudServiceConfigServerGitSettingSshAuth;
}
export declare function springCloudServiceConfigServerGitSettingToTerraform(struct?: SpringCloudServiceConfigServerGitSettingOutputReference | SpringCloudServiceConfigServerGitSetting): any;
export declare class SpringCloudServiceConfigServerGitSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SpringCloudServiceConfigServerGitSetting | undefined;
    set internalValue(value: SpringCloudServiceConfigServerGitSetting | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _searchPaths?;
    get searchPaths(): string[];
    set searchPaths(value: string[]);
    resetSearchPaths(): void;
    get searchPathsInput(): string[] | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
    private _httpBasicAuth;
    get httpBasicAuth(): SpringCloudServiceConfigServerGitSettingHttpBasicAuthOutputReference;
    putHttpBasicAuth(value: SpringCloudServiceConfigServerGitSettingHttpBasicAuth): void;
    resetHttpBasicAuth(): void;
    get httpBasicAuthInput(): SpringCloudServiceConfigServerGitSettingHttpBasicAuth | undefined;
    private _repository?;
    get repository(): SpringCloudServiceConfigServerGitSettingRepository[] | cdktf.IResolvable;
    set repository(value: SpringCloudServiceConfigServerGitSettingRepository[] | cdktf.IResolvable);
    resetRepository(): void;
    get repositoryInput(): cdktf.IResolvable | SpringCloudServiceConfigServerGitSettingRepository[] | undefined;
    private _sshAuth;
    get sshAuth(): SpringCloudServiceConfigServerGitSettingSshAuthOutputReference;
    putSshAuth(value: SpringCloudServiceConfigServerGitSettingSshAuth): void;
    resetSshAuth(): void;
    get sshAuthInput(): SpringCloudServiceConfigServerGitSettingSshAuth | undefined;
}
export interface SpringCloudServiceNetwork {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#app_network_resource_group SpringCloudService#app_network_resource_group}
    */
    readonly appNetworkResourceGroup?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#app_subnet_id SpringCloudService#app_subnet_id}
    */
    readonly appSubnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#cidr_ranges SpringCloudService#cidr_ranges}
    */
    readonly cidrRanges: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#service_runtime_network_resource_group SpringCloudService#service_runtime_network_resource_group}
    */
    readonly serviceRuntimeNetworkResourceGroup?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#service_runtime_subnet_id SpringCloudService#service_runtime_subnet_id}
    */
    readonly serviceRuntimeSubnetId: string;
}
export declare function springCloudServiceNetworkToTerraform(struct?: SpringCloudServiceNetworkOutputReference | SpringCloudServiceNetwork): any;
export declare class SpringCloudServiceNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SpringCloudServiceNetwork | undefined;
    set internalValue(value: SpringCloudServiceNetwork | undefined);
    private _appNetworkResourceGroup?;
    get appNetworkResourceGroup(): string;
    set appNetworkResourceGroup(value: string);
    resetAppNetworkResourceGroup(): void;
    get appNetworkResourceGroupInput(): string | undefined;
    private _appSubnetId?;
    get appSubnetId(): string;
    set appSubnetId(value: string);
    get appSubnetIdInput(): string | undefined;
    private _cidrRanges?;
    get cidrRanges(): string[];
    set cidrRanges(value: string[]);
    get cidrRangesInput(): string[] | undefined;
    private _serviceRuntimeNetworkResourceGroup?;
    get serviceRuntimeNetworkResourceGroup(): string;
    set serviceRuntimeNetworkResourceGroup(value: string);
    resetServiceRuntimeNetworkResourceGroup(): void;
    get serviceRuntimeNetworkResourceGroupInput(): string | undefined;
    private _serviceRuntimeSubnetId?;
    get serviceRuntimeSubnetId(): string;
    set serviceRuntimeSubnetId(value: string);
    get serviceRuntimeSubnetIdInput(): string | undefined;
}
export interface SpringCloudServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#create SpringCloudService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#delete SpringCloudService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#read SpringCloudService#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#update SpringCloudService#update}
    */
    readonly update?: string;
}
export declare function springCloudServiceTimeoutsToTerraform(struct?: SpringCloudServiceTimeoutsOutputReference | SpringCloudServiceTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SpringCloudServiceTimeouts | undefined;
    set internalValue(value: SpringCloudServiceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface SpringCloudServiceTrace {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#connection_string SpringCloudService#connection_string}
    */
    readonly connectionString?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#instrumentation_key SpringCloudService#instrumentation_key}
    */
    readonly instrumentationKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service#sample_rate SpringCloudService#sample_rate}
    */
    readonly sampleRate?: number;
}
export declare function springCloudServiceTraceToTerraform(struct?: SpringCloudServiceTraceOutputReference | SpringCloudServiceTrace): any;
export declare class SpringCloudServiceTraceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SpringCloudServiceTrace | undefined;
    set internalValue(value: SpringCloudServiceTrace | undefined);
    private _connectionString?;
    get connectionString(): string;
    set connectionString(value: string);
    resetConnectionString(): void;
    get connectionStringInput(): string | undefined;
    private _instrumentationKey?;
    get instrumentationKey(): string;
    set instrumentationKey(value: string);
    resetInstrumentationKey(): void;
    get instrumentationKeyInput(): string | undefined;
    private _sampleRate?;
    get sampleRate(): number;
    set sampleRate(value: number);
    resetSampleRate(): void;
    get sampleRateInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service azurerm_spring_cloud_service}
*/
export declare class SpringCloudService extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_service azurerm_spring_cloud_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudServiceConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudServiceConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundPublicIpAddresses(): string[];
    requiredNetworkTrafficRules(index: string): SpringCloudServiceRequiredNetworkTrafficRules;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    resetSkuName(): void;
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _configServerGitSetting;
    get configServerGitSetting(): SpringCloudServiceConfigServerGitSettingOutputReference;
    putConfigServerGitSetting(value: SpringCloudServiceConfigServerGitSetting): void;
    resetConfigServerGitSetting(): void;
    get configServerGitSettingInput(): SpringCloudServiceConfigServerGitSetting | undefined;
    private _network;
    get network(): SpringCloudServiceNetworkOutputReference;
    putNetwork(value: SpringCloudServiceNetwork): void;
    resetNetwork(): void;
    get networkInput(): SpringCloudServiceNetwork | undefined;
    private _timeouts;
    get timeouts(): SpringCloudServiceTimeoutsOutputReference;
    putTimeouts(value: SpringCloudServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SpringCloudServiceTimeouts | undefined;
    private _trace;
    get trace(): SpringCloudServiceTraceOutputReference;
    putTrace(value: SpringCloudServiceTrace): void;
    resetTrace(): void;
    get traceInput(): SpringCloudServiceTrace | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
