import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlElasticpoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool#db_dtu_max SqlElasticpool#db_dtu_max}
    */
    readonly dbDtuMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool#db_dtu_min SqlElasticpool#db_dtu_min}
    */
    readonly dbDtuMin?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool#dtu SqlElasticpool#dtu}
    */
    readonly dtu: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool#edition SqlElasticpool#edition}
    */
    readonly edition: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool#location SqlElasticpool#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool#name SqlElasticpool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool#pool_size SqlElasticpool#pool_size}
    */
    readonly poolSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool#resource_group_name SqlElasticpool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool#server_name SqlElasticpool#server_name}
    */
    readonly serverName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool#tags SqlElasticpool#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool#timeouts SqlElasticpool#timeouts}
    */
    readonly timeouts?: SqlElasticpoolTimeouts;
}
export interface SqlElasticpoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool#create SqlElasticpool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool#delete SqlElasticpool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool#read SqlElasticpool#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool#update SqlElasticpool#update}
    */
    readonly update?: string;
}
export declare function sqlElasticpoolTimeoutsToTerraform(struct?: SqlElasticpoolTimeoutsOutputReference | SqlElasticpoolTimeouts | cdktf.IResolvable): any;
export declare class SqlElasticpoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SqlElasticpoolTimeouts | undefined;
    set internalValue(value: SqlElasticpoolTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool azurerm_sql_elasticpool}
*/
export declare class SqlElasticpool extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sql_elasticpool azurerm_sql_elasticpool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SqlElasticpoolConfig
    */
    constructor(scope: Construct, id: string, config: SqlElasticpoolConfig);
    get creationDate(): string;
    private _dbDtuMax?;
    get dbDtuMax(): number;
    set dbDtuMax(value: number);
    resetDbDtuMax(): void;
    get dbDtuMaxInput(): number | undefined;
    private _dbDtuMin?;
    get dbDtuMin(): number;
    set dbDtuMin(value: number);
    resetDbDtuMin(): void;
    get dbDtuMinInput(): number | undefined;
    private _dtu?;
    get dtu(): number;
    set dtu(value: number);
    get dtuInput(): number | undefined;
    private _edition?;
    get edition(): string;
    set edition(value: string);
    get editionInput(): string | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _poolSize?;
    get poolSize(): number;
    set poolSize(value: number);
    resetPoolSize(): void;
    get poolSizeInput(): number | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serverName?;
    get serverName(): string;
    set serverName(value: string);
    get serverNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): SqlElasticpoolTimeoutsOutputReference;
    putTimeouts(value: SqlElasticpoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SqlElasticpoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
