import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageContainerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_container#container_access_type StorageContainer#container_access_type}
    */
    readonly containerAccessType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_container#metadata StorageContainer#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_container#name StorageContainer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_container#storage_account_name StorageContainer#storage_account_name}
    */
    readonly storageAccountName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_container#timeouts StorageContainer#timeouts}
    */
    readonly timeouts?: StorageContainerTimeouts;
}
export interface StorageContainerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_container#create StorageContainer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_container#delete StorageContainer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_container#read StorageContainer#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_container#update StorageContainer#update}
    */
    readonly update?: string;
}
export declare function storageContainerTimeoutsToTerraform(struct?: StorageContainerTimeoutsOutputReference | StorageContainerTimeouts | cdktf.IResolvable): any;
export declare class StorageContainerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): StorageContainerTimeouts | undefined;
    set internalValue(value: StorageContainerTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_container azurerm_storage_container}
*/
export declare class StorageContainer extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_container azurerm_storage_container} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageContainerConfig
    */
    constructor(scope: Construct, id: string, config: StorageContainerConfig);
    private _containerAccessType?;
    get containerAccessType(): string;
    set containerAccessType(value: string);
    resetContainerAccessType(): void;
    get containerAccessTypeInput(): string | undefined;
    get hasImmutabilityPolicy(): cdktf.IResolvable;
    get hasLegalHold(): cdktf.IResolvable;
    get id(): string;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get resourceManagerId(): string;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    get storageAccountNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): StorageContainerTimeoutsOutputReference;
    putTimeouts(value: StorageContainerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): StorageContainerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
