import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageDisksPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_disks_pool#availability_zones StorageDisksPool#availability_zones}
    */
    readonly availabilityZones: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_disks_pool#location StorageDisksPool#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_disks_pool#name StorageDisksPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_disks_pool#resource_group_name StorageDisksPool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_disks_pool#sku_name StorageDisksPool#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_disks_pool#subnet_id StorageDisksPool#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_disks_pool#tags StorageDisksPool#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_disks_pool#timeouts StorageDisksPool#timeouts}
    */
    readonly timeouts?: StorageDisksPoolTimeouts;
}
export interface StorageDisksPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_disks_pool#create StorageDisksPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_disks_pool#delete StorageDisksPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_disks_pool#read StorageDisksPool#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_disks_pool#update StorageDisksPool#update}
    */
    readonly update?: string;
}
export declare function storageDisksPoolTimeoutsToTerraform(struct?: StorageDisksPoolTimeoutsOutputReference | StorageDisksPoolTimeouts | cdktf.IResolvable): any;
export declare class StorageDisksPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): StorageDisksPoolTimeouts | undefined;
    set internalValue(value: StorageDisksPoolTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_disks_pool azurerm_storage_disks_pool}
*/
export declare class StorageDisksPool extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_disks_pool azurerm_storage_disks_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageDisksPoolConfig
    */
    constructor(scope: Construct, id: string, config: StorageDisksPoolConfig);
    private _availabilityZones?;
    get availabilityZones(): string[];
    set availabilityZones(value: string[]);
    get availabilityZonesInput(): string[] | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): StorageDisksPoolTimeoutsOutputReference;
    putTimeouts(value: StorageDisksPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): StorageDisksPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
