import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StreamAnalyticsFunctionJavascriptUdfConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#name StreamAnalyticsFunctionJavascriptUdf#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#resource_group_name StreamAnalyticsFunctionJavascriptUdf#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#script StreamAnalyticsFunctionJavascriptUdf#script}
    */
    readonly script: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#stream_analytics_job_name StreamAnalyticsFunctionJavascriptUdf#stream_analytics_job_name}
    */
    readonly streamAnalyticsJobName: string;
    /**
    * input block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#input StreamAnalyticsFunctionJavascriptUdf#input}
    */
    readonly input: StreamAnalyticsFunctionJavascriptUdfInput[] | cdktf.IResolvable;
    /**
    * output block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#output StreamAnalyticsFunctionJavascriptUdf#output}
    */
    readonly output: StreamAnalyticsFunctionJavascriptUdfOutput;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#timeouts StreamAnalyticsFunctionJavascriptUdf#timeouts}
    */
    readonly timeouts?: StreamAnalyticsFunctionJavascriptUdfTimeouts;
}
export interface StreamAnalyticsFunctionJavascriptUdfInput {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#type StreamAnalyticsFunctionJavascriptUdf#type}
    */
    readonly type: string;
}
export declare function streamAnalyticsFunctionJavascriptUdfInputToTerraform(struct?: StreamAnalyticsFunctionJavascriptUdfInput | cdktf.IResolvable): any;
export interface StreamAnalyticsFunctionJavascriptUdfOutput {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#type StreamAnalyticsFunctionJavascriptUdf#type}
    */
    readonly type: string;
}
export declare function streamAnalyticsFunctionJavascriptUdfOutputToTerraform(struct?: StreamAnalyticsFunctionJavascriptUdfOutputOutputReference | StreamAnalyticsFunctionJavascriptUdfOutput): any;
export declare class StreamAnalyticsFunctionJavascriptUdfOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): StreamAnalyticsFunctionJavascriptUdfOutput | undefined;
    set internalValue(value: StreamAnalyticsFunctionJavascriptUdfOutput | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface StreamAnalyticsFunctionJavascriptUdfTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#create StreamAnalyticsFunctionJavascriptUdf#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#delete StreamAnalyticsFunctionJavascriptUdf#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#read StreamAnalyticsFunctionJavascriptUdf#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf#update StreamAnalyticsFunctionJavascriptUdf#update}
    */
    readonly update?: string;
}
export declare function streamAnalyticsFunctionJavascriptUdfTimeoutsToTerraform(struct?: StreamAnalyticsFunctionJavascriptUdfTimeoutsOutputReference | StreamAnalyticsFunctionJavascriptUdfTimeouts | cdktf.IResolvable): any;
export declare class StreamAnalyticsFunctionJavascriptUdfTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): StreamAnalyticsFunctionJavascriptUdfTimeouts | undefined;
    set internalValue(value: StreamAnalyticsFunctionJavascriptUdfTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf azurerm_stream_analytics_function_javascript_udf}
*/
export declare class StreamAnalyticsFunctionJavascriptUdf extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_function_javascript_udf azurerm_stream_analytics_function_javascript_udf} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StreamAnalyticsFunctionJavascriptUdfConfig
    */
    constructor(scope: Construct, id: string, config: StreamAnalyticsFunctionJavascriptUdfConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _script?;
    get script(): string;
    set script(value: string);
    get scriptInput(): string | undefined;
    private _streamAnalyticsJobName?;
    get streamAnalyticsJobName(): string;
    set streamAnalyticsJobName(value: string);
    get streamAnalyticsJobNameInput(): string | undefined;
    private _input?;
    get input(): StreamAnalyticsFunctionJavascriptUdfInput[] | cdktf.IResolvable;
    set input(value: StreamAnalyticsFunctionJavascriptUdfInput[] | cdktf.IResolvable);
    get inputInput(): cdktf.IResolvable | StreamAnalyticsFunctionJavascriptUdfInput[] | undefined;
    private _output;
    get output(): StreamAnalyticsFunctionJavascriptUdfOutputOutputReference;
    putOutput(value: StreamAnalyticsFunctionJavascriptUdfOutput): void;
    get outputInput(): StreamAnalyticsFunctionJavascriptUdfOutput | undefined;
    private _timeouts;
    get timeouts(): StreamAnalyticsFunctionJavascriptUdfTimeoutsOutputReference;
    putTimeouts(value: StreamAnalyticsFunctionJavascriptUdfTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): StreamAnalyticsFunctionJavascriptUdfTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
